using System;
using Server.Items;
using Server.Network;
using Server.Spells;

namespace Server.Items
{
	public abstract class NoAmmoRanged : BaseMeleeWeapon
	{
		public abstract int EffectID{ get; }
		public abstract int EffectHue{ get; }
		public override int DefHitSound{ get{ return 0x234; } }
		public override int DefMissSound{ get{ return 0x238; } }

		public override SkillName DefSkill{ get{ return SkillName.Archery; } }
		public override WeaponType DefType{ get{ return WeaponType.Ranged; } }

		private bool m_Balanced;
		
		[CommandProperty( AccessLevel.GameMaster )]
		public bool Balanced
		{
			get{ return m_Balanced; }
			set{ m_Balanced = value; InvalidateProperties(); }
		}
		
		public NoAmmoRanged( int itemID ) : base( itemID )
		{
		}

		public NoAmmoRanged( Serial serial ) : base( serial )
		{
		}

		public override TimeSpan OnSwing( Mobile attacker, Mobile defender )
		{
			// Make sure we've been standing still for one second
			if ( DateTime.Now > (attacker.LastMoveTime + TimeSpan.FromSeconds( 0.5 )) || (Core.AOS && WeaponAbility.GetCurrentAbility( attacker ) is MovingShot) || (m_Balanced) )
			{
				bool canSwing = true;

				if ( Core.AOS )
				{
					canSwing = ( !attacker.Paralyzed && !attacker.Frozen );

					if ( canSwing )
					{
						Spell sp = attacker.Spell as Spell;

						canSwing = ( sp == null || !sp.IsCasting || !sp.BlocksMovement );
					}
				}
            
            if ( canSwing && attacker.HarmfulCheck( defender ) )
				{
					attacker.DisruptiveAction();
					attacker.Send( new Swing( 0, attacker, defender ) );

					if ( OnFired( attacker, defender ) )
					{
						if ( CheckHit( attacker, defender ) )
							OnHit( attacker, defender );
						else
							OnMiss( attacker, defender );
					}
				}
				
				attacker.RevealingAction();

				return GetDelay( attacker );
			}
			else
			{
				return TimeSpan.FromSeconds( 0.25 );
			}
		}


		public virtual bool OnFired( Mobile attacker, Mobile defender )
		{
			// attacker.MovingEffect( defender, EffectID, 7, 0, false, true, EffectHue, 0 );
			attacker.MovingEffect( defender, EffectID, 18, 1, false, false, EffectHue, 0 );
			return true;
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 2 ); // version
			writer.Write( (bool) m_Balanced );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();

			switch ( version )
			{
				case 2:
					{
						m_Balanced = reader.ReadBool();
						break;
					}
				case 1:
					{
						break;
					}
				case 0:
					{
						/*m_EffectID =*/ reader.ReadInt();
						break;
					}
			}
		}

		// public override int ComputeDamage( Mobile attacker, Mobile defender )
		// {
		// double damage = GetBaseDamage( attacker );
		// return (int)damage;
		// }
	}
}
