using System;
using Server.Network;
using Server;

namespace Server.Misc
{
	public class FoodDecayTimer : Timer
	{
		public static void Initialize()
		{
			new FoodDecayTimer().Start();
		}

		public FoodDecayTimer() : base( TimeSpan.FromMinutes( 10 ), TimeSpan.FromMinutes( 10 ) )
		{
			Priority = TimerPriority.OneMinute;
		}

		protected override void OnTick()
		{
			FoodDecay();			
		}

		public static void FoodDecay()
		{
			foreach ( NetState state in NetState.Instances )
			{
				HungerDecay( state.Mobile );
				ThirstDecay( state.Mobile );
			}
		}

		public static void HungerDecay( Mobile m )
		{
			if ( m != null )
			{
            if ( m.Hunger > 0 )
            {
               m.Hunger -= 1;
               
               if ( m.Player )
               {
                  if ( m.Hunger == 2 || m.Hunger == 3 )
                     m.SendMessage( 34, "Cas na neco k jidlu!" );
                  else if ( m.Hunger == 1 )
                     m.SendMessage( 34, "Zacinas mit velky hlad!" );
               }
            }
            else
            {
               if ( m.Player )
                  m.SendMessage( 33, "Mas nesnesitelny hlad!" );
            }
         }
				
		}

		public static void ThirstDecay( Mobile m )
		{
			if ( m != null && m.Thirst >= 1 )
				m.Thirst -= 1;
		}
	}
}