using System;
using Server;
using Server.Items;
using Server.Mobiles;

namespace Server.Items
{
	public enum HolidayBell2008Type
	{
		Vinz,
		Bobasek,
		Renfier,
		Rabbit
	}

	public enum HolidayBell2008Sound
	{
		Sound1,
		Sound2,
		Sound3,
		Sound4,
		Sound5,
		Sound6
	}

	public class HolidayBell2008 : Item
	{
		private HolidayBell2008Type m_Type;
		private HolidayBell2008Sound m_Sound;

		[CommandProperty( AccessLevel.GameMaster )]
		public HolidayBell2008Type Type
		{
			get{ return m_Type; }
			set{ m_Type = value; }
		}

		[CommandProperty( AccessLevel.GameMaster )]
		public HolidayBell2008Sound Sound
		{
			get{ return m_Sound; }
			set{ m_Sound = value; }
		}

		[Constructable]
		public HolidayBell2008() : base( 0x1C12 )
		{

			HolidayBell2008Type randomtype = (HolidayBell2008Type)Utility.Random((int)HolidayBell2008Type.Rabbit+1);

			m_Type = randomtype;

			HolidayBell2008Sound randomsound = (HolidayBell2008Sound)Utility.Random((int)HolidayBell2008Sound.Sound6+1);

			m_Sound = randomsound;

			LootType = LootType.Blessed;

			Hue = Utility.RandomList( 1150 , 55, 65, 75, 85, 95, 105, 115, 125, 135, 145, 30, 35, 37 );
		}

      		public override void OnDoubleClick( Mobile from ) 
      		{  
			if ( m_Sound == HolidayBell2008Sound.Sound1 )
			{
				from.PlaySound( 0x100 );
			}
			else if ( m_Sound == HolidayBell2008Sound.Sound2 )
			{
				from.PlaySound( 0x101 );
			}
			else if ( m_Sound == HolidayBell2008Sound.Sound3 )
			{
				from.PlaySound( 0x103 );
			}
			else if ( m_Sound == HolidayBell2008Sound.Sound4 )
			{
				from.PlaySound( 0x104 );
			}
			else if ( m_Sound == HolidayBell2008Sound.Sound5 )
			{
				from.PlaySound( 0x16 );
			}
			else if ( m_Sound == HolidayBell2008Sound.Sound6 )
			{
				from.PlaySound( 0x428 );
			}
			else
			{
				from.SendMessage( "INTERNAL ERROR: Please contact a gamemaster about your bell." );
			}
      		}

		public HolidayBell2008( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version

			writer.WriteEncodedInt( (int) m_Type );

			writer.WriteEncodedInt( (int) m_Sound );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
			
			m_Type = (HolidayBell2008Type)reader.ReadEncodedInt();

			m_Sound = (HolidayBell2008Sound)reader.ReadEncodedInt();
		}

		public override void AddNameProperty(ObjectPropertyList list)
		{
			if ( m_Type == HolidayBell2008Type.Vinz )
			{
				list.Add( "a holiday bell from Vinz Clortho" );
			}
			else if ( m_Type == HolidayBell2008Type.Bobasek )
			{
				list.Add( "a holiday bell from Bobasek" );
			}
			else if ( m_Type == HolidayBell2008Type.Rabbit )
			{
				list.Add( "a holiday bell from Rabbit" );
			}
 			else if ( m_Type == HolidayBell2008Type.Renfier )
			{
				list.Add( "a holiday bell from Renfier" );
			}
			else
			{
				list.Add( "a holiday bell" );
			}
		}
	}
}