using System;
using Server.Items;
using Server.Mobiles;

namespace Server.Misc
{
    public class XmassGiftGiver : GiftGiver
    {
        public static void Initialize()
        {
            GiftGiving.Register(new XmassGiftGiver());
        }

        public override DateTime Start { get { return new DateTime(2017, 12, 22); } }
        public override DateTime Finish { get { return new DateTime(2018, 1, 6); } }

        public override void GiveGift(Mobile mob)
        {
            GiftBox box = new GiftBox();

            box.DropItem(new HolidayTreeDeed());
            box.DropItem(new BankCheck(30000));
            box.DropItem(new Tokens(100));
            box.DropItem(new FireworksWand());
            box.DropItem(new CandyCane());
            box.DropItem(new GingerBreadCookie());
            box.DropItem(new Snowman2008(mob.RawName));
            box.DropItem(new CechovniMince(50));

            MagicScroll ms = new MagicScroll();
            ms.BlessedFor = mob;
            box.DropItem(ms);

            SkillBall sb = new SkillBall(20.0);
            sb.BlessedFor = mob;
            box.DropItem(sb);

            LegendaryLevelUpScroll ls = new LegendaryLevelUpScroll();
            ls.BlessedFor = mob;
            ls.LootType = LootType.Blessed;
            box.DropItem(ls);

            int theHue = Utility.RandomMinMax(2521, 2648);

            AllDyeTubsAll dt = new AllDyeTubsAll();
            dt.BlessedFor = mob;
            dt.DyedHue = theHue;
            dt.Hue = theHue;
            dt.Charges = 3;
            box.DropItem(dt);

            switch (GiveGift(mob, box))
            {
                case GiftResult.Backpack:
                    mob.SendMessage(0x482, "Vesele vanoce od realizacniho tymu shardu Auberon! Darek byl umisten do tveho batohu.");
                    break;
                case GiftResult.BankBox:
                    mob.SendMessage(0x482, "Vesele vanoce od realizacniho tymu shardu Auberon! Darek byl umisten do tve banky.");
                    break;
            }
        }
    }
}