// Hireable Medic by Haazen Aug 2005  Requires NeRuns BaseHire.cs
using System;
using Server;
using Server.Items;
using Server.Spells;
using Server.Spells.First;
using Server.Mobiles;
using Server.Misc;
using System.Collections;

namespace Server.Mobiles
{

	//[CorpseName( "a corpse" )]
	public class Medic : BaseHire
	{

		[Constructable]
		public Medic () : base( AIType.AI_Mage )
		{

         Name = NameList.RandomName( "female" );
			Title = " the Medic";
			Body = 0x191;
			Female = true;
			Hue = 0x83EF;
			Blessed = true;
			ControlSlots = 3;

			SetStr( 400 );
			SetDex( 200 );
			SetInt( 400 );

			SetHits( 2500 );
			SetDamage( 25, 35 );

			SetSkill( SkillName.EvalInt, 200.0 );
			SetSkill( SkillName.Magery, 200.0 );
			SetSkill( SkillName.Meditation, 200.0 );
			SetSkill( SkillName.Anatomy, 300.0 );
			SetSkill( SkillName.Fencing, 200.0 );
			SetSkill( SkillName.MagicResist, 200.0 );
			SetSkill( SkillName.Tactics, 200.0 );

			AddItem( new PonyTail( Utility.RandomHairHue() ) );
         
         int DressHue = Utility.RandomList( 1153, 1150, 56, 51, 46, 41, 36, 26, 16, 66, 86, 96, 191 );
         
			AddItem( new PlainDress( DressHue ) );

			AddItem( new ThighBoots() );

			AddItem( new Obi( 132 ) );
			AddItem( new TricorneHat( DressHue ) );

		}

		public override void GenerateLoot()
		{

		}

      private DateTime m_NextHeal;
      
		public override void OnThink()
      {
         base.OnThink();
			if ( DateTime.Now < m_NextHeal)
				return;
            		
			m_NextHeal = DateTime.Now + TimeSpan.FromSeconds( 0.75 );	// tady zmenit rychlost kouzleni
			
			Timer.DelayCall( TimeSpan.FromSeconds( 0.75 ), new TimerCallback( HealMe ) );		// a tady taky na stejny cislo	
	  	}

		private void HealMe()
		{
         foreach ( Mobile m in this.GetMobilesInRange( 10 ) )                                                    
			if ( this.ControlMaster == m )
			{
           	if ( m.Alive && m.InRange( this, 10 ) ) 
            { 
					if ( m.Hits < (m.HitsMax - 15) )
					{
					    if ( !new HealSpell( this, null ).Cast() )
					    {
						    new HealSpell( this, null ).Cast();
					       m.Hits += 15; // defaul 15 - mnozstvi zivotu co se pridaji ke klasickymu heal kouzlu ktery dava kolem 10ti
					    }
					}
				}
			}
      }

		public Medic( Serial serial ) : base( serial )
		{
		}



      		public override void Serialize( GenericWriter writer ) 
      		{ 
         	base.Serialize( writer ); 

         	writer.Write( (int) 0 ); // version 
      		} 

      		public override void Deserialize( GenericReader reader ) 
      		{ 
         	base.Deserialize( reader ); 

         	int version = reader.ReadInt(); 
		}
   	}
}
