/*
*   Scripter : Morgion
*   Author : Lord Mashadow // Avalon Team
*   Generator : Avalon Script Creator
*   Created at :  21.9.2007 23:25:46
*   Thank you for using this tool, feel free to visit our web site  www.avalon.gen.tr
*/
using System;
using Server;
using Server.Items;
using Server.Mobiles;

namespace Server.Mobiles
{
    //[CorpseName( "a scorpion king corpse" )]
    public class ScorpionKing : BaseCreature
    {
        [Constructable]
        public ScorpionKing() : base( AIType.AI_Mage, FightMode.Closest, 10, 1, 0.2, 0.4 )
        {
            Name = "Scorpion King";
            Hue = 51;
            Body = 48;
            BaseSoundID = 397;

    			SetStr( 196, 220 );
    			SetDex( 126, 145 );
    			SetInt( 286, 310 );
    
    			SetHits( 358, 562 );
    
    			SetDamage( 7, 17 );
    
    			SetDamageType( ResistanceType.Physical, 20 );
    			SetDamageType( ResistanceType.Poison, 80 );
    
    			SetResistance( ResistanceType.Physical, 20, 40 );
    			SetResistance( ResistanceType.Fire, 20, 30 );
    			SetResistance( ResistanceType.Cold, 20, 30 );
    			SetResistance( ResistanceType.Poison, 90, 100 );
    			SetResistance( ResistanceType.Energy, 20, 30 );
    
    			SetSkill( SkillName.EvalInt, 65.1, 100.0 );
    			SetSkill( SkillName.Magery, 85.1, 110.0 );
    			SetSkill( SkillName.Meditation, 65.1, 80.0 );
    			SetSkill( SkillName.MagicResist, 45.1, 60.0 );
    			SetSkill( SkillName.Tactics, 55.1, 70.0 );
    			SetSkill( SkillName.Wrestling, 60.1, 75.0 );
    
    			Fame = 9000;
    			Karma = -5000;
    
    			VirtualArmor = 46;

            PackItem( new GreaterPoisonPotion() );
        }

		public override Poison PoisonImmune{ get{ return Poison.Lethal; } }
		public override Poison HitPoison{ get{ return Poison.Lethal; } }
		public override int TreasureMapLevel{ get{ return 4; } }
		public override bool IsNotScaredOfDeath{ get{ return true; } } //neutika pri malem poctu hp
		
		public override void GenerateLoot()
		{
			AddLoot( LootPack.FilthyRich );
		}

		public override WeaponAbility GetWeaponAbility()
		{
			return WeaponAbility.BleedAttack;
      }

        public ScorpionKing( Serial serial ) : base( serial )
        {
        }

        public override void Serialize( GenericWriter writer )
        {
            base.Serialize( writer );
            writer.Write( (int) 0 );
        }

        public override void Deserialize(GenericReader reader)
        {
            base.Deserialize( reader );
            int version = reader.ReadInt();
        }
    }
}