//Modifications for the Mobile Abilities Package are done and created by Peoharen.
using System;
using Server;
using Server.Items;

namespace Server.Mobiles
{
	//[CorpseName( "an ice elemental corpse" )]
	public class IceElemental : BaseCreature
	{
		private DateTime m_Delay = DateTime.Now;

		[Constructable]
		public IceElemental () : base( AIType.AI_Mage, FightMode.Closest, 10, 1, 0.2, 0.4 )
		{
			Name = "an ice elemental";
			Body = 161;
			BaseSoundID = 268;

			SetStr( 252, 260 );
			SetDex( 100, 115 );
			SetInt( 220, 230 );

			SetHits( 300, 500 );

			SetDamage( 15, 21 );

			SetDamageType( ResistanceType.Physical, 25 );
			SetDamageType( ResistanceType.Cold, 75 );

			SetResistance( ResistanceType.Physical, 35, 45 );
			SetResistance( ResistanceType.Fire, 25, 30 );
			SetResistance( ResistanceType.Cold, 50, 60 );
			SetResistance( ResistanceType.Poison, 30, 50 );
			SetResistance( ResistanceType.Energy, 30, 50 );

			SetSkill( SkillName.EvalInt, 50.5, 60.0 );
			SetSkill( SkillName.Magery, 50.5, 60.0 );
			SetSkill( SkillName.MagicResist, 30.1, 80.0 );
			SetSkill( SkillName.Tactics, 80.1, 100.0 );
			SetSkill( SkillName.Wrestling, 90.1, 105.0 );

			Fame = 4000;
			Karma = -4000;

			VirtualArmor = 40;

			PackItem( new BlackPearl() );
			PackReg( 3 );
		}

		public override void GenerateLoot()
		{
			AddLoot( LootPack.Average, 2 );
			AddLoot( LootPack.Gems, 2 );
		}
		public override bool BleedImmune{ get{ return true; } }

		public override void OnThink()
		{
			if ( DateTime.Now > m_Delay )
			{
				int bonus = ( this.Map == Map.Felucca ) ? 80 : 0;
            
            Ability.Aura( this, 20 + bonus, 40 + bonus, 2, 3, 0, "The icy cold wind chills you to the bone" );
				m_Delay = DateTime.Now + TimeSpan.FromSeconds( Utility.RandomMinMax( 5, 10 ) );
			}
			base.OnThink();
		}

		public IceElemental( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}