﻿//Created By -Cybella-

using System;
using Server;
using Server.Misc;
using Server.Items;

namespace Server.Mobiles
{
	//[CorpseName( "a caveman corpse" )]
	public class Caveman : BaseCreature
	{
		private DateTime m_Summon = DateTime.Now;
		private bool m_Summoner = false;
		
		public override WeaponAbility GetWeaponAbility()
		{
			return WeaponAbility.CrushingBlow;
		}

      [Constructable]
		public Caveman() : base( AIType.AI_Melee, FightMode.Closest, 10, 1, 0.15, 0.4 )
		{
			Name = "a caveman";
			Body = 400;
         Hue = Utility.RandomMinMax( 1023, 1058 );
         int facialhue = Utility.RandomMinMax( 1023, 1058 );
         HairItemID = 0x203C;
         HairHue = facialhue;
         FacialHairItemID = 0x204C;
         FacialHairHue = facialhue;
			
         SetStr( 800, 900 );
			SetDex( 66, 90 );
			SetInt( 10, 15 );

			SetDamage( 15, 30 );
			SetHits( 351, 475 );
			SetMana( 300 );
			
			SetDamageType( ResistanceType.Physical, 80 );
			SetDamageType( ResistanceType.Poison, 20 );

         SetResistance( ResistanceType.Physical, 75, 85 );
			SetResistance( ResistanceType.Fire, 50 );
			SetResistance( ResistanceType.Cold, 70 );
			SetResistance( ResistanceType.Poison, 50 );
			SetResistance( ResistanceType.Energy, 50 );

			SetSkill( SkillName.MagicResist, 45.0, 77.5 );
			SetSkill( SkillName.Macing, 105.0, 120.5 );
			SetSkill( SkillName.Tactics, 105.0, 120.5 );
			SetSkill( SkillName.Wrestling, 105.0, 125.5 );
			SetSkill( SkillName.Anatomy, 95.0, 127.5 );
			SetSkill( SkillName.Parry, 90.0, 100.0 );
			
			if ( Utility.RandomDouble() < 0.01 )				
				AddItem( new CavemansIdol() );
				
			if ( Utility.RandomDouble() < 0.3 )
            PackItem( Loot.RandomNewPotion() );
			
			Fame = 9000;
			Karma = -15000;
			VirtualArmor = 55;
                  
         Club melee = new Club();
         melee.Resource = CraftResource.Cedar;
         melee.Hue = 0;
			AddItem( melee );

			HalfApron apron = new HalfApron();
			apron.Hue = Utility.RandomMinMax( 1873, 1899 );
			apron.Name = "loin cloth";
			apron.Movable = false;
			AddItem( apron );

			if ( Utility.RandomDouble() < 0.2 )
			{
            RidablePolar mt = new RidablePolar();
			   mt.Hue = Utility.RandomList( 1149, 1809, 1881, 1880, 1890, 1899 );
			   mt.Rider = this;	
         }
         else
         {
            if ( Utility.RandomDouble() < 0.3 )
               m_Summoner = true;
         }
         
         PackItem( new Bandage( Utility.RandomMinMax( 10, 20 ) ) );	
		}

		public override void OnActionCombat()
		{
			if ( m_Summoner && this.Combatant != null && DateTime.Now > m_Summon && Utility.RandomDouble() < 0.3 )
			{
				Mobile target = this.Combatant;
				
				this.Say( Utility.RandomBool() ? "Urgh Urgh!" : "Grrr!" );

				Map map = this.Map;

				if ( map == null )
					return;

				BaseCreature animal = new MeerGrizzlyBear();
				bool validLocation = false;
				Point3D loc = this.Location;

				for ( int j = 0; !validLocation && j < 10; ++j )
				{
					int x = X + Utility.Random( 2 ) - 1;
					int y = Y + Utility.Random( 2 ) - 1;
					int z = map.GetAverageZ( x, y );

					if ( validLocation = map.CanFit( x, y, this.Z, 16, false, false ) )
						loc = new Point3D( x, y, Z );
					else if ( validLocation = map.CanFit( x, y, z, 16, false, false ) )
						loc = new Point3D( x, y, z );
				}

				animal.Team = this.Team;
				animal.MoveToWorld( loc, map );
				animal.Combatant = target;

				m_Summon = DateTime.Now + TimeSpan.FromSeconds( Utility.RandomMinMax( 20, 45 ) );
			}
			base.OnActionCombat();
		}

		public override void GenerateLoot()
		{
			AddLoot( LootPack.FilthyRich );
			AddLoot( LootPack.Gems );
		}

		public override bool HasBreath{ get{ return true; } }
      public override int BreathPhysicalDamage { get { return 100; } }
      public override int BreathFireDamage { get { return 0; } }
      public override int BreathEffectItemID { get { return 6011; } }
      public override int BreathEffectSound { get { return 568; } }
		public override bool AutoDispel{ get{ return true; } }
		public override bool BardImmune{ get{ return true; } }
		public override bool Unprovokable{ get{ return true; } }
		public override bool Uncalmable{ get{ return true; } }
		public override bool CanRummageCorpses{ get{ return true; } }
		public override bool AlwaysMurderer{ get{ return true; } }
		public override bool ShowFameTitle{ get{ return false; } }
		public override bool IsNotScaredOfDeath{ get{ return true; } } //neutika pri malem poctu hp
		
		public override bool OnBeforeDeath()
		{
			IMount mount = this.Mount;

			if ( mount != null )
				mount.Rider = null;

			if ( mount is Mobile )
				((Mobile)mount).Delete();

			return base.OnBeforeDeath();
		}

		public override void AlterMeleeDamageTo( Mobile to, ref int damage )
		{
			damage = DecreaseDamage( to, damage );
			
         if ( to is Xanthos.Interfaces.IEvoCreature )
				damage *= 7;
		}

		public Caveman( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}