//Created By -Cybella-

using System;
using Server;
using Server.Misc;
using Server.Items;

namespace Server.Mobiles
{
	//[CorpseName( "a chaos dragoon corpse" )]
	public class ChaosDragoon : BaseCreature
	{
		public CraftResource res;
		
		public override WeaponAbility GetWeaponAbility()
		{
			return WeaponAbility.CrushingBlow;
		}

      [Constructable]
		public ChaosDragoon() : base( AIType.AI_Paladin, FightMode.Closest, 10, 1, 0.15, 0.4 )
		{
			Name = "a chaos dragoon";
			Body = 0x190;
         Hue = Utility.RandomSkinHue();
			
         SetStr( 800, 900 );
			SetDex( 66, 90 );
			SetInt( 200, 500 );

			SetDamage( 20, 30 );
			SetHits( 951, 975 );
			SetMana( 2651, 2975 );
			
			SetDamageType( ResistanceType.Physical, 50 );
			SetDamageType( ResistanceType.Cold, 50 );

         SetResistance( ResistanceType.Physical, 45, 55 );
			SetResistance( ResistanceType.Fire, 35 );
			SetResistance( ResistanceType.Cold, 50 );
			SetResistance( ResistanceType.Poison, 35 );
			SetResistance( ResistanceType.Energy, 35 );

			SetSkill( SkillName.Chivalry, 105.0, 120.5 );
			SetSkill( SkillName.MagicResist, 45.0, 77.5 );
			SetSkill( SkillName.Swords, 105.0, 120.5 );
			SetSkill( SkillName.Fencing, 105.0, 120.5 );
			SetSkill( SkillName.Macing, 105.0, 120.5 );
			SetSkill( SkillName.Tactics, 105.0, 120.5 );
			SetSkill( SkillName.Wrestling, 105.0, 125.5 );
			SetSkill( SkillName.Anatomy, 95.0, 127.5 );
			SetSkill( SkillName.Parry, 90.0, 100.0 );
			
			if ( Utility.RandomDouble() < 0.05 )				
				PackItem( new GlassSword() );
				
         PackItem( Loot.RandomNewPotion() );
			
			Fame = 20000;
			Karma = -15000;
			VirtualArmor = 55;

			switch ( Utility.Random( 6 ) )
			{
				case 0: res = CraftResource.BlackScales; break;
				case 1: res = CraftResource.RedScales; break;
				case 2: res = CraftResource.BlueScales; break;
				case 3: res = CraftResource.YellowScales; break;
				case 4: res = CraftResource.GreenScales; break;
				case 5: res = CraftResource.WhiteScales; break;
			}
                  
         BaseWeapon melee = new Kryss();

			switch (Utility.Random( 3 ))
			{
				case 0: melee = new Kryss(); break;
				case 1: melee = new Broadsword(); break;
			   case 2: melee = new Katana(); break;

         }

			DragonChest Tunic = new DragonChest();
			Tunic.Resource = res;
			Tunic.Movable = false;
			AddItem( Tunic );
			

			DragonLegs Legs = new DragonLegs();
			Legs.Resource = res;
			Legs.Movable = false;
			AddItem( Legs );
			

			DragonArms Arms = new DragonArms();
			Arms.Resource = res;
			Arms.Movable = false;
			AddItem( Arms );
			

			DragonGloves Gloves = new DragonGloves();
			Gloves.Resource = res;
			Gloves.Movable = false;
			AddItem( Gloves );
			

			DragonHelm Helm = new DragonHelm();
			Helm.Resource = res;
			Helm.Movable = false;
			AddItem( Helm );
			
                  
         melee.Movable = false;
			AddItem( melee );

         ChaosShield shield = new ChaosShield();
			shield.Movable = false;
			AddItem( shield );

			
			AddItem( new Boots( 0x455 ) );
			AddItem( new Shirt( Utility.RandomMetalHue() ) );
			
         int amount = Utility.RandomMinMax( 1, 5 );

			switch ( res )
			{
				case CraftResource.BlackScales: AddItem( new BlackScales( amount ) ); break;
				case CraftResource.RedScales: AddItem( new RedScales( amount ) ); break;
				case CraftResource.BlueScales: AddItem( new BlueScales( amount ) ); break;
				case CraftResource.YellowScales: AddItem( new YellowScales( amount ) ); break;
				case CraftResource.GreenScales: AddItem( new GreenScales( amount ) ); break;
				case CraftResource.WhiteScales: AddItem( new WhiteScales( amount ) ); break;
			}
			
         switch (Utility.Random( 9 ))
			{
				case 0: res = CraftResource.DullCopper; break;
				case 1: res = CraftResource.ShadowIron; break;
				case 2: res = CraftResource.Copper; break;
				case 3: res = CraftResource.Bronze; break;
				case 4: res = CraftResource.Gold; break;
				case 5: res = CraftResource.Agapite; break;
				case 6: res = CraftResource.Verite; break;
				case 7: res = CraftResource.Valorite; break;
				case 8: res = CraftResource.Iron; break;
			}
                  

         ScaledSwampDragon mt = new ScaledSwampDragon();
			mt.Hue = CraftResources.GetHue( res );
			mt.Rider = this;	
         
         PackItem( new Bandage( Utility.RandomMinMax( 10, 20 ) ) );	
		}

		public override int GetIdleSound()
		{
			return 0x2CE;
		}

		public override int GetDeathSound()
		{
			return 0x2CC;
		}

		public override int GetHurtSound()
		{
			return 0x2D1;
		}

		public override int GetAttackSound()
		{
			return 0x2C8;
		}

		public override void GenerateLoot()
		{
			AddLoot( LootPack.UltraRich );
			AddLoot( LootPack.Rich );
			AddLoot( LootPack.Gems );
		}
		
		public override void OnGotMeleeAttack( Mobile attacker )
		{
			base.OnGotMeleeAttack( attacker );
			attacker.Stam -= Utility.Random( 6, 16 );
			attacker.Mana -= Utility.Random( 4, 20 );
			Ability.TurnPet( attacker );
		}
		
		public override void OnGaveMeleeAttack( Mobile defender )
		{
			base.OnGaveMeleeAttack( defender );

			if ( 0.02 >= Utility.RandomDouble() )
				Ability.CriticalHit( defender );

         Ability.DamageArmor( defender, 1, 2 );
		}

		public override bool HasBreath{ get{ return true; } }
		public override bool AutoDispel{ get{ return true; } }
		public override bool BardImmune{ get{ return true; } }
		public override bool Unprovokable{ get{ return true; } }
		public override bool Uncalmable{ get{ return true; } }
		public override bool CanRummageCorpses{ get{ return true; } }
		public override bool AlwaysMurderer{ get{ return true; } }
		public override bool ShowFameTitle{ get{ return false; } }
		public override bool IsNotScaredOfDeath{ get{ return true; } } //neutika pri malem poctu hp
		
		public override bool OnBeforeDeath()
		{
			IMount mount = this.Mount;

			if ( mount != null )
				mount.Rider = null;

			if ( mount is Mobile )
				((Mobile)mount).Delete();

			return base.OnBeforeDeath();
		}

		public override void AlterMeleeDamageTo( Mobile to, ref int damage )
		{
			damage = DecreaseDamage( to, damage );
			
         if ( to is Xanthos.Interfaces.IEvoCreature )
				damage *= 5;
		}

		public ChaosDragoon( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}