using System;
using System.Collections;
using Server.Items;
using Server.ContextMenus;
using Server.Misc;
using Server.Network;

namespace Server.Mobiles 
{ 
	//[CorpseName( "a dark paladin corpse" )]
   public class DarkPaladin : BaseCreature 
	{ 
		private DateTime m_NextSpeechTime = DateTime.Now;
		
		string[] DarkPaladinSay = new string[]
		{
			"Zabijení lidí jako jseš ty, je taky cnost!",
			"Připrav se na smrt!",
			"Bude mi ctí tě zbavit tvého života!",
			 "Budeš se plazit u mých nohou a prosit za rychlou smrt!",
			 "Měl jsi šanci utéct, teď už máš smůlu!",
			 "Neboj, umřeš rychle a skoro bez bolestně!",
			 "Zhyň!",
			 "Copak myslíš že s touhle výzbrojí proti mě něco zmůžeš?"
		};
      
		public override WeaponAbility GetWeaponAbility()
		{
			switch ( Utility.Random( 3 ) )
			{
				default:
				case 0: return WeaponAbility.DoubleStrike;
				case 1: return WeaponAbility.WhirlwindAttack;
				case 2: return WeaponAbility.CrushingBlow;
			}
		}

      [Constructable] 
		public DarkPaladin() : base( AIType.AI_Paladin, FightMode.Closest, 10, 1, 0.2, 0.4 ) 
		{ 
			Title = "the Dark Paladin"; 

			SpeechHue = Utility.RandomDyedHue();
			Hue = Utility.RandomSkinHue(); 
			Body = 0x190; 
			Name = NameList.RandomName( "male" );
			TithingPoints = 10000;
         Item hair = new Item( Utility.RandomList( 0x203B, 0x2049, 0x2048, 0x204A ) ); 
         hair.Hue = Utility.RandomNeutralHue(); 
         hair.Layer = Layer.Hair; 
         hair.Movable = false; 
         AddItem( hair ); 

         if( Utility.RandomBool() )
         {
            Item beard = new Item( Utility.RandomList( 0x203E, 0x203F, 0x2040, 0x2041, 0x204B, 0x204C, 0x204D ) );
            beard.Hue = hair.Hue;
            beard.Layer = Layer.FacialHair;
            beard.Movable = false;
            AddItem( beard );
         }

			new FrenziedOstard().Rider = this; 

         BaseArmor arms = new PlateArms();
         arms.Resource = CraftResource.Obsidian;
         arms.Movable = ( Utility.RandomDouble() < 0.1 ) ? true : false;
         AddItem( arms );
         BaseArmor chest = new PlateChest();
         chest.Resource = CraftResource.Obsidian;
         chest.Movable = ( Utility.RandomDouble() < 0.1 ) ? true : false;
         AddItem( chest );
         BaseArmor gloves = new PlateGloves();
         gloves.Resource = CraftResource.Obsidian;
         gloves.Movable = ( Utility.RandomDouble() < 0.1 ) ? true : false;
         AddItem( gloves );
         BaseArmor gorget = new PlateGorget();
         gorget.Resource = CraftResource.Obsidian;
         gorget.Movable = ( Utility.RandomDouble() < 0.1 ) ? true : false;
         AddItem( gorget );
         BaseArmor legs = new PlateLegs();
         legs.Resource = CraftResource.Obsidian;
         legs.Movable = ( Utility.RandomDouble() < 0.1 ) ? true : false;
         AddItem( legs );
         Item cloak = new Cloak();
         cloak.Hue = 1156;
         cloak.Name = "Dark Paladin's Cloak";
         cloak.Movable = ( Utility.RandomDouble() < 0.1 ) ? true : false;
         AddItem( cloak );
         Item sash = new BodySash();
         sash.Hue = 1156;
         sash.Name = "Dark Paladin's Sash";
         sash.Movable = ( Utility.RandomDouble() < 0.1 ) ? true : false;
         AddItem( sash );
         Item talisman = new ChaoticAmulet();
         talisman.Movable = ( Utility.RandomDouble() < 0.005 ) ? true : false;
         AddItem( talisman );

  			switch ( Utility.Random( 4 ) )
  			{
  				case 0:
            {
               BaseArmor platehelm = new PlateHelm();
               platehelm.Resource = CraftResource.Obsidian;
               platehelm.Movable = ( Utility.RandomDouble() < 0.1 ) ? true : false;
               AddItem( platehelm );
            }
            break;
  				case 1:
            {
               BaseArmor norsehelm = new NorseHelm();
               norsehelm.Resource = CraftResource.Obsidian;
               norsehelm.Movable = ( Utility.RandomDouble() < 0.1 ) ? true : false;
               AddItem( norsehelm );
            }
            break;
  				case 2:
            {
               BaseArmor closehelm = new CloseHelm();
               closehelm.Resource = CraftResource.Obsidian;
               closehelm.Movable = ( Utility.RandomDouble() < 0.1 ) ? true : false;
               AddItem( closehelm );
            }
            break;
  				case 3:
            {
               BaseArmor helmet = new Helmet();
               helmet.Resource = CraftResource.Obsidian;
               helmet.Movable = ( Utility.RandomDouble() < 0.1 ) ? true : false;
               AddItem( helmet );
            }
            break;
  			}

  			switch ( Utility.Random( 2 ) )
  			{
  			    case 0:
               switch ( Utility.Random( 3 ))
      			{
      				case 0:
      				{
                     BaseWeapon bardiche = new Bardiche();
                     bardiche.Resource = CraftResource.Moonstone;
                     bardiche.Movable = ( Utility.RandomDouble() < 0.1 ) ? true : false;
                     bardiche.Quality = WeaponQuality.Exceptional; 
                     AddItem( bardiche );
                  }
                  break;
      				case 1:
      				{
                     BaseWeapon halberd = new Halberd();
                     halberd.Resource = CraftResource.Moonstone;
                     halberd.Movable = ( Utility.RandomDouble() < 0.1 ) ? true : false;
                     halberd.Quality = WeaponQuality.Exceptional;
                     AddItem( halberd );
                  }
                  break;
      				case 2:
      				{
                     BaseWeapon twohandedsword = new TwoHandedSword();
                     twohandedsword.Resource = CraftResource.Moonstone;
                     twohandedsword.Movable = ( Utility.RandomDouble() < 0.1 ) ? true : false;
                     twohandedsword.Quality = WeaponQuality.Exceptional;
                     AddItem( twohandedsword );
                  }
                  break;
      			}    
  			    break;
  			    case 1:
               switch ( Utility.Random( 2 ))
      			{
      				case 0:
      				{
                     BaseWeapon broadsword = new Broadsword();
                     broadsword.Resource = CraftResource.Moonstone;
                     broadsword.Movable = ( Utility.RandomDouble() < 0.1 ) ? true : false;
                     broadsword.Quality = WeaponQuality.Exceptional;
                     AddItem( broadsword );
                  }
                  break;
      				case 1:
      				{
                     BaseWeapon vikingsword = new VikingSword();
                     vikingsword.Resource = CraftResource.Moonstone;
                     vikingsword.Movable = ( Utility.RandomDouble() < 0.1 ) ? true : false;
                     vikingsword.Quality = WeaponQuality.Exceptional;
                     AddItem( vikingsword );
                  }
                  break;
      			} 
               switch ( Utility.Random( 4 ))
      			{
      				case 0:
      				{
                     BaseShield metalshield = new MetalShield();
                     metalshield.Resource = CraftResource.Moonstone;
                     metalshield.Movable = ( Utility.RandomDouble() < 0.1 ) ? true : false;
                     AddItem( metalshield );
                  }
                  break;
      				case 1:
      				{
                     BaseShield metalkiteshield = new MetalKiteShield();
                     metalkiteshield.Resource = CraftResource.Moonstone;
                     metalkiteshield.Movable = ( Utility.RandomDouble() < 0.1 ) ? true : false;
                     AddItem( metalkiteshield );
                  }
                  break;
      				case 2:
      				{
                     BaseShield heatershield = new HeaterShield();
                     heatershield.Resource = CraftResource.Moonstone;
                     heatershield.Movable = ( Utility.RandomDouble() < 0.1 ) ? true : false;
                     AddItem( heatershield );
                  }
                  break;
      				case 3:
      				{
                     BaseShield chaosshield = new ChaosShield();
                     chaosshield.Resource = CraftResource.Moonstone;
                     chaosshield.Movable = ( Utility.RandomDouble() < 0.1 ) ? true : false;
                     AddItem( chaosshield );
                  }
                  break;
      			} 
  			    break;           
         }
         
         SetStr( 850, 1100 );
			SetDex( 120, 180 );
			SetInt( 400, 590 );

			SetDamage( 20, 30 );
			SetHits( 1051, 1275 );
			SetMana( 2651, 2975 );
			
			SetDamageType( ResistanceType.Physical, 10 );
			SetDamageType( ResistanceType.Cold, 90 );

			SetResistance( ResistanceType.Physical, 25, 40 );
			SetResistance( ResistanceType.Fire, 25, 40 );
			SetResistance( ResistanceType.Cold, 25, 40 );
			SetResistance( ResistanceType.Poison, 25, 40 );
			SetResistance( ResistanceType.Energy, 25, 40 );

			SetSkill( SkillName.Chivalry, 125.0, 150.5 );
			SetSkill( SkillName.MagicResist, 45.0, 77.5 );
			SetSkill( SkillName.Swords, 105.0, 120.5 );
			SetSkill( SkillName.Tactics, 105.0, 120.5 );
			SetSkill( SkillName.Wrestling, 105.0, 125.5 );
			SetSkill( SkillName.Anatomy, 95.0, 127.5 );
			SetSkill( SkillName.Parry, 95.0, 127.5 );
			
			if ( Utility.RandomDouble() < 0.04 )				
				PackItem( new GlassSword() );

         PackItem( new Bandage( Utility.RandomMinMax( 5, 20 ) ) );
         PackItem( Loot.RandomNewPotion() );

			Fame = 20000;
			Karma = -15000;
			VirtualArmor = 55;
		}
		
		public override void GenerateLoot()
		{
			AddLoot( LootPack.UltraRich );
			AddLoot( LootPack.Rich );
		}

		public override bool ShowFameTitle{ get{ return false; } }
		public override bool AlwaysMurderer{ get{ return true; } }
		public override int TreasureMapLevel{ get{ return 4; } }
		public override bool BardImmune{ get{ return true; } }
		public override bool Unprovokable{ get{ return true; } }
		public override bool Uncalmable{ get{ return true; } }
		public override bool CanRummageCorpses{ get{ return true; } }
		public override bool IsNotScaredOfDeath{ get{ return true; } } //neutika pri malem poctu hp
		
		public DarkPaladin( Serial serial ) : base( serial ) 
		{ 
		}
		
		public override void AlterMeleeDamageTo( Mobile to, ref int damage )
		{
			damage = DecreaseDamage( to, damage );
         
         if ( to is Xanthos.Interfaces.IEvoCreature )
				damage *= 4;
		}
		
		public override void OnGaveMeleeAttack( Mobile defender )
		{
			base.OnGaveMeleeAttack( defender );

			if ( 0.02 >= Utility.RandomDouble() )
			{
            Ability.DamageArmor( defender, 2, 5 );
				Ability.CriticalHit( defender );
         }
		}
		
      public override bool OnBeforeDeath()
      {
          IMount mount = this.Mount;
          if   ( mount != null )
          mount.Rider = null;
          
          if ( mount is Mobile )
          {
              ((Mobile)mount).Delete();
          }
          return base.OnBeforeDeath();
      }
      
      public override void OnDeath( Container c )
      {
         base.OnDeath( c );
         
          Mobile m = FindMostRecentDamager( false );
  
          if ( m != null && m.Player )
          {
             bool gainedPath = false;
  
             if ( VirtueHelper.Award( m, VirtueName.Justice, 250, ref gainedPath ) )
             {
                if ( gainedPath )
                   m.SendLocalizedMessage( 1049367 ); // You have gained a path in Justice!
                else
                   m.SendLocalizedMessage( 1049363 ); // You have gained in Justice.
  
                m.FixedParticles( 0x375A, 9, 20, 5027, EffectLayer.Waist );
                m.PlaySound( 0x1F7 );  
             }
          }
      }
      
		public override void OnMovement( Mobile m, Point3D oldLocation )
		{
			if ( DateTime.Now > m_NextSpeechTime && m.InRange( this, 3 ) && m is PlayerMobile && !m.Hidden )
			{
				m_NextSpeechTime = DateTime.Now + TimeSpan.FromSeconds( Utility.RandomMinMax( 30, 50 ) );
				SayRandom( DarkPaladinSay, this );
				this.Move( GetDirectionTo( m.Location ) );
			}
		}
		
		private static void SayRandom( string[] say, Mobile m )
		{
			m.Say( say[Utility.Random( say.Length )] );
		}

		public override void Serialize( GenericWriter writer ) 
		{ 
			base.Serialize( writer ); 

			writer.Write( (int) 0 ); // version 
		} 

		public override void Deserialize( GenericReader reader ) 
		{ 
			base.Deserialize( reader ); 

			int version = reader.ReadInt(); 
		} 
	} 
}