using System;
using System.Collections;
using Server.Items;
using Server.ContextMenus;
using Server.Misc;
using Server.Network;

namespace Server.Mobiles
{
	public class Murderer : BaseCreature
	{
		private DateTime m_NextSpeechTime = DateTime.Now;

		string[] MurdererSay = new string[]
		{

			"Peníze nebo život!",
			"Připrav se na smrt!",
         "Předtím než ti uříznu od pasu měšec se zlaťákama, uříznu ti hlavu!",
         "Tvojí hlavu si napíchnu na meč a vystavím si ji doma, jestli mi hned nedáš peníze",
         "Vrahem se prý člověk nerodí, ale stává. U mě je to výjimka",
         "Kamarád mi říkal ať tu dýku odložím, tak jsem ji odložil - jemu do hrudi",
         "Máš na vejběr hejsku, dej mi všecky prachy sic ti podříznu kejhák",
         "Rodiče říkali že krást se nemá, ale mě to prostě baví",
         "Copak máš v tom pytli? Tak se na tebe podíváme...",
         "Naval sem kořalku tuláku! Že nemáš? Tak to si tě pěkně prohledám... po smrti!",
         "Stůj! jenom si procvičím vrhání nožů na cíl. Skoro nic se ti nestane",
         "Uvážu ti za chřtán provaz a přivážu k rozzuřenému koni, uvidíme kdo se bude smát poslední!",
         "Jen pojď, dnes jsem ještě před snídaní nevraždil!",
         "Zhyň bídáku! Tvou hlavu pošlu příbuzným.",
         "Budeš se plazit u mých nohou a prosit za rychlou smrt!",
         "Vykoupu se v tvé krvi!",
         "Měl jsi šanci utéct, teď už máš smůlu!",
         "Neboj, umřeš rychle a skoro bez bolestně!",
         "Zhyň!",
         "Konečně jsem tě dopadl, pamatuješ? Že ne? Obehrál jsi mě v kostkách!",
         "Tak to jsi ty? Zabil jsi mi kamaráda, za to tě pošlu na onen svět!",
         "Stát, ani krok, dál tě pustím jen přes moji mršinu!",
         "Až tě vyřídím, nakrmím tvým masem divoké psy a hlavu napíchnu na kůl, kde ti vrány vyklovou oči",
         "Odhalil jsi naše tajemství! Za to budeš pykat"
		};

		public override WeaponAbility GetWeaponAbility()
		{
			switch (Utility.Random(3))
			{
				default:
				case 0: return WeaponAbility.DoubleStrike;
				case 1: return WeaponAbility.WhirlwindAttack;
				case 2: return WeaponAbility.CrushingBlow;
			}
		}

		[Constructable]
		public Murderer() : base(AIType.AI_Melee, FightMode.Closest, 10, 1, 0.2, 0.4)
		{
			InitStats(100, 125, 25);
			Title = "the Murderer";

			SpeechHue = Utility.RandomDyedHue();

			Hue = Utility.RandomSkinHue();

			if (Female = Utility.RandomBool())
			{
				Body = 0x191;
				Name = NameList.RandomName("female");
			}
			else
			{
				Body = 0x190;
				Name = NameList.RandomName("male");
			}

			new Horse().Rider = this;

			switch (Utility.Random(2))
			{
				case 0:
                AddItem(new PlateArms());
				AddItem(new PlateChest());
				AddItem(new PlateGloves());
				AddItem(new PlateGorget());
				AddItem(new PlateLegs());
				switch (Utility.Random(4))
				{
					case 0: AddItem(new PlateHelm()); break;
					case 1: AddItem(new NorseHelm()); break;
					case 2: AddItem(new CloseHelm()); break;
					case 3: AddItem(new Helmet()); break;
				}

				break;
				case 1:
                AddItem(new ChainChest());
				AddItem(new ChainLegs());
				AddItem(new PlateGloves());
				AddItem(new ChainCoif());
				AddItem(new Boots(Utility.RandomNeutralHue()));
				break;
			}

			switch (Utility.Random(2))
			{
				case 0:
               switch (Utility.Random(14))
				{
					case 0: AddItem(new Spear()); break;
					case 1: AddItem(new Bardiche()); break;
					case 2: AddItem(new Halberd()); break;
					case 3: AddItem(new BladedStaff()); break;
					case 4: AddItem(new DoubleBladedStaff()); break;
					case 5: AddItem(new Scythe()); break;
					case 6: AddItem(new WarHammer()); break;
					case 7: AddItem(new HammerPick()); break;
					case 8: AddItem(new TwoHandedAxe()); break;
					case 9: AddItem(new LargeBattleAxe()); break;
					case 10: AddItem(new BattleAxe()); break;
					case 11: AddItem(new WarAxe()); break;
					case 12: AddItem(new DoubleAxe()); break;
					case 13: AddItem(new ExecutionersAxe()); break;
				}

				break;
				case 1:
               switch (Utility.Random(9))
				{
					case 0: AddItem(new BoneHarvester()); break;
					case 1: AddItem(new Mace()); break;
					case 2: AddItem(new WarMace()); break;
					case 3: AddItem(new WarFork()); break;
					case 4: AddItem(new Scimitar()); break;
					case 5: AddItem(new Broadsword()); break;
					case 6: AddItem(new Kryss()); break;
					case 7: AddItem(new VikingSword()); break;
					case 8: AddItem(new Club()); break;
				}

				switch (Utility.Random(9))
				{
					case 0: AddItem(new BronzeShield()); break;
					case 1: AddItem(new MetalShield()); break;
					case 2: AddItem(new WoodenShield()); break;
					case 3: AddItem(new Buckler()); break;
					case 4: AddItem(new MetalKiteShield()); break;
					case 5: AddItem(new HeaterShield()); break;
					case 6: AddItem(new WoodenKiteShield()); break;
					case 7: AddItem(new ChaosShield()); break;
					case 8: AddItem(new OrderShield()); break;
				}

				break;
			}

			SetStr(206, 300);
			SetDex(50, 75);
			SetInt(61, 75);

			SetDamage(10, 25);
			SetHits(351, 475);

			SetSkill(SkillName.Fencing, 76.0, 90.5);
			SetSkill(SkillName.Macing, 75.0, 90.5);
			SetSkill(SkillName.MagicResist, 45.0, 77.5);
			SetSkill(SkillName.Swords, 75.0, 90.5);
			SetSkill(SkillName.Tactics, 75.0, 90.5);
			SetSkill(SkillName.Wrestling, 35.0, 87.5);
			SetSkill(SkillName.Anatomy, 65.0, 87.5);

			PackItem(new Bandage(Utility.RandomMinMax(5, 15)));
			// 			PackGold( 80, 150 );

			Fame = 5000;
			Karma = -7000;
			VirtualArmor = 0;
			Utility.AssignRandomHair(this);
		}

		public override void GenerateLoot()
		{
			AddLoot(LootPack.Average, 2);
		}

		public override bool AlwaysMurderer { get { return true; } }
		public override int TreasureMapLevel { get { return 2; } }
		public override bool Unprovokable { get { return true; } }

		public Murderer(Serial serial) : base(serial)
		{
		}

		public override void OnGaveMeleeAttack(Mobile defender)
		{
			base.OnGaveMeleeAttack(defender);

			if (0.05 >= Utility.RandomDouble())
			{
				Ability.DamageArmor(defender, 2, 5);
				Ability.CriticalHit(defender);
			}
		}

		public override bool OnBeforeDeath()
		{
			IMount mount = this.Mount;
			if (mount != null)
				mount.Rider = null;

			if (mount is Mobile)
			{
				((Mobile)mount).Delete();
			}

			return base.OnBeforeDeath();
		}

		public override void OnDeath(Container c)
		{
			base.OnDeath(c);

			Mobile m = FindMostRecentDamager(false);

			if (m != null && m.Player)
			{
				bool gainedPath = false;

				if (VirtueHelper.Award(m, VirtueName.Justice, 250, ref gainedPath))
				{
					if (gainedPath)
						m.SendLocalizedMessage(1049367); // You have gained a path in Justice!
					else
						m.SendLocalizedMessage(1049363); // You have gained in Justice.

                m.FixedParticles(0x375A, 9, 20, 5027, EffectLayer.Waist);
					m.PlaySound(0x1F7);
				}
			}
		}

		public override void OnMovement(Mobile m, Point3D oldLocation)
		{
			if (DateTime.Now > m_NextSpeechTime && m.InRange(this, 3) && m is PlayerMobile && !m.Hidden)
			{
				m_NextSpeechTime = DateTime.Now + TimeSpan.FromSeconds(Utility.RandomMinMax(30, 50));
				SayRandom(MurdererSay, this);
				this.Move(GetDirectionTo(m.Location));
			}
		}

		private static void SayRandom(string[] say, Mobile m)
		{
			m.Say(say[Utility.Random(say.Length)]);
		}

		public override void Serialize(GenericWriter writer)
		{
			base.Serialize(writer);

			writer.Write((int) 0); // version 
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);

			int version = reader.ReadInt();
		}
	}
}