using System;
using System.Collections;
using Server.Items;
using Server.Misc;
using Server.Network;

namespace Server.Mobiles
{
	public class MurdererArcher : BaseCreature
	{
		[Constructable]
		public MurdererArcher() : base(AIType.AI_Archer, FightMode.Closest, 10, 1, 0.2, 0.4)
		{
			InitStats(100, 125, 25);
			Title = "the Murderer";

			SpeechHue = Utility.RandomDyedHue();

			Hue = Utility.RandomSkinHue();

			if (Female = Utility.RandomBool())
			{
				Body = 0x191;
				Name = NameList.RandomName("female");
			}
			else
			{
				Body = 0x190;
				Name = NameList.RandomName("male");
			}

			new Horse().Rider = this;

			AddItem(new ChainChest());
			AddItem(new ChainLegs());
			AddItem(new RingmailGloves());
			AddItem(new ChainCoif());
			AddItem(new Boots(Utility.RandomNeutralHue()));
			AddItem(new Cloak(Utility.RandomNeutralHue()));

			switch (Utility.Random(3))
			{
				case 0:
		         AddItem(new Bow());
				PackItem(new Arrow(Utility.RandomMinMax(5, 10)));
				break;
				case 1:
		         AddItem(new Crossbow());
				PackItem(new Bolt(Utility.RandomMinMax(5, 10)));
				break;
				case 2:
		         AddItem(new HeavyCrossbow());
				PackItem(new Bolt(Utility.RandomMinMax(5, 10)));
				break;
			}

			SetStr(106, 200);
			SetDex(110, 155);
			SetInt(61, 75);

			SetDamage(10, 20);
			SetHits(351, 375);

			SetSkill(SkillName.Archery, 96.0, 120.5);
			SetSkill(SkillName.MagicResist, 45.0, 77.5);
			SetSkill(SkillName.Tactics, 75.0, 90.5);
			SetSkill(SkillName.Wrestling, 35.0, 87.5);
			SetSkill(SkillName.Anatomy, 85.0, 87.5);

			PackItem(new Bandage(Utility.RandomMinMax(5, 10)));
			// 			PackGold( 80, 150 );

			Fame = 5000;
			Karma = -7000;
			VirtualArmor = 0;
			Utility.AssignRandomHair(this);
		}

		public override void GenerateLoot()
		{
			AddLoot(LootPack.Average, 2);
		}

		public override bool AlwaysMurderer { get { return true; } }
		public override bool BardImmune { get { return true; } }

		public MurdererArcher(Serial serial) : base(serial)
		{
		}

		public override bool OnBeforeDeath()
		{
			IMount mount = this.Mount;
			if (mount != null)
				mount.Rider = null;

			if (mount is Mobile)
			{
				((Mobile)mount).Delete();
			}

			return base.OnBeforeDeath();
		}

		public override void OnDeath(Container c)
		{
			base.OnDeath(c);

			Mobile m = FindMostRecentDamager(false);

			if (m != null && m.Player)
			{
				bool gainedPath = false;

				if (VirtueHelper.Award(m, VirtueName.Justice, 250, ref gainedPath))
				{
					if (gainedPath)
						m.SendLocalizedMessage(1049367); // You have gained a path in Justice!
					else
						m.SendLocalizedMessage(1049363); // You have gained in Justice.

                m.FixedParticles(0x375A, 9, 20, 5027, EffectLayer.Waist);
					m.PlaySound(0x1F7);
				}
			}
		}

		public override void Serialize(GenericWriter writer)
		{
			base.Serialize(writer);

			writer.Write((int) 0); // version 
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);

			int version = reader.ReadInt();
		}
	}
}