using System;
using System.Collections;
using Server.Items;
using Server.ContextMenus;
using Server.Misc;
using Server.Network;

namespace Server.Mobiles
{
	public class MurdererMage : BaseCreature
	{
		public override bool ClickTitle { get { return false; } }

		[Constructable]
		public MurdererMage() : base(AIType.AI_Mage, FightMode.Closest, 10, 5, 0.2, 0.4)
		{
			SpeechHue = Utility.RandomDyedHue();
			Title = "the murderer";
			Hue = Utility.RandomSkinHue();

			Utility.AssignRandomHair(this);
			if (this.Female = Utility.RandomBool())
			{
				Body = 0x191;
				Name = NameList.RandomName("female");
				AddItem(new PlainDress(Utility.RandomNeutralHue()));
			}
			else
			{
				Body = 0x190;
				Name = NameList.RandomName("male");
				AddItem(new Robe(Utility.RandomNeutralHue()));
				Utility.AssignRandomFacialHair(this, HairHue);
				AddItem(new Cloak(Utility.RandomNeutralHue()));
			}

			new Horse().Rider = this;

			SetStr(96, 150);
			SetDex(50, 105);
			SetInt(231, 275);

			SetDamage(10, 33);

			SetSkill(SkillName.MagicResist, 45.0, 77.5);
			SetSkill(SkillName.Magery, 105.0, 120.5);
			SetSkill(SkillName.Meditation, 75.0, 90.5);
			SetSkill(SkillName.EvalInt, 105.0, 120.5);
			SetSkill(SkillName.Wrestling, 75.0, 87.5);
			SetSkill(SkillName.Tactics, 65.0, 70.5);

			Fame = 8000;
			Karma = -9000;
			VirtualArmor = 40;

			PackReg(2, 8);
			// 			PackGold( 100, 150 );
			AddItem(new BlackStaff());
		}

		public override void GenerateLoot()
		{
			AddLoot(LootPack.Average, 2);
			AddLoot(LootPack.MedScrolls);
		}

		public override bool AlwaysMurderer { get { return true; } }
		public override int TreasureMapLevel { get { return 2; } }
		public override bool Unprovokable { get { return true; } }
		public override bool Uncalmable { get { return true; } }

		public MurdererMage(Serial serial) : base(serial)
		{
		}

		public override void Serialize(GenericWriter writer)
		{
			base.Serialize(writer);

			writer.Write((int) 0); // version
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);

			int version = reader.ReadInt();
		}

		public override bool OnBeforeDeath()
		{
			IMount mount = this.Mount;
			if (mount != null)
				mount.Rider = null;

			if (mount is Mobile)
			{
				((Mobile)mount).Delete();
			}

			return base.OnBeforeDeath();
		}

		public override void OnDeath(Container c)
		{
			base.OnDeath(c);

			Mobile m = FindMostRecentDamager(false);

			if (m != null && m.Player)
			{
				bool gainedPath = false;

				if (VirtueHelper.Award(m, VirtueName.Justice, 250, ref gainedPath))
				{
					if (gainedPath)
						m.SendLocalizedMessage(1049367); // You have gained a path in Justice!
					else
						m.SendLocalizedMessage(1049363); // You have gained in Justice.

                m.FixedParticles(0x375A, 9, 20, 5027, EffectLayer.Waist);
					m.PlaySound(0x1F7);
				}
			}
		}
	}
}