using System;
using System.Collections;
using Server.Items;
using Server.ContextMenus;
using Server.Misc;
using Server.Network;

namespace Server.Mobiles
{
	public class MurdererNecro : BaseCreature
	{
		public override bool ClickTitle { get { return false; } }

		[Constructable]
		public MurdererNecro() : base(AIType.AI_Necromage, FightMode.Closest, 10, 5, 0.2, 0.4)
		{
			SpeechHue = Utility.RandomDyedHue();
			Title = "the murderer";
			Hue = Utility.RandomSkinHue();

			Utility.AssignRandomHair(this);
			if (this.Female = Utility.RandomBool())
			{
				Body = 0x191;
				Name = NameList.RandomName("female");
			}
			else
			{
				Body = 0x190;
				Name = NameList.RandomName("male");
				Utility.AssignRandomFacialHair(this, HairHue);
			}

			new Horse().Rider = this;

			int Barva = Utility.RandomNeutralHue();
			BoneChest chest = new BoneChest();
			chest.Hue = Barva;
			AddItem(chest);
			BoneArms arms = new BoneArms();
			arms.Hue = Barva;
			AddItem(arms);
			BoneGloves gloves = new BoneGloves();
			gloves.Hue = Barva;
			AddItem(gloves);
			BoneLegs legs = new BoneLegs();
			legs.Hue = Barva;
			AddItem(legs);
			BoneHelm helm = new BoneHelm();
			helm.Hue = Barva;
			AddItem(helm);

			SetStr(96, 150);
			SetDex(50, 105);
			SetInt(161, 275);

			SetDamage(10, 33);

			SetSkill(SkillName.MagicResist, 45.0, 77.5);
			SetSkill(SkillName.Magery, 95.0, 130.5);
			SetSkill(SkillName.Necromancy, 95.0, 130.5);
			SetSkill(SkillName.Meditation, 75.0, 90.5);
			SetSkill(SkillName.SpiritSpeak, 105.0, 150.5);
			SetSkill(SkillName.EvalInt, 95.0, 120.5);
			SetSkill(SkillName.Wrestling, 75.0, 87.5);
			SetSkill(SkillName.Tactics, 75.0, 90.5);

			Fame = 8000;
			Karma = -9000;
			VirtualArmor = 20;

			PackNecroScroll(Utility.RandomMinMax(1, 2));
			PackNecroReg(2, 8);
			// 			PackGold( 110, 150 );
		}

		public override void GenerateLoot()
		{
			AddLoot(LootPack.Average, 2);
			AddLoot(LootPack.MedScrolls);
		}

		public override bool AlwaysMurderer { get { return true; } }
		public override bool Unprovokable { get { return true; } }
		public override bool Uncalmable { get { return true; } }

		public MurdererNecro(Serial serial) : base(serial)
		{
		}

		public override void Serialize(GenericWriter writer)
		{
			base.Serialize(writer);

			writer.Write((int) 0); // version
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);

			int version = reader.ReadInt();
		}

		public override bool OnBeforeDeath()
		{
			IMount mount = this.Mount;
			if (mount != null)
				mount.Rider = null;

			if (mount is Mobile)
			{
				((Mobile)mount).Delete();
			}

			return base.OnBeforeDeath();
		}

		public override void OnDeath(Container c)
		{
			base.OnDeath(c);

			Mobile m = FindMostRecentDamager(false);

			if (m != null && m.Player)
			{
				bool gainedPath = false;

				if (VirtueHelper.Award(m, VirtueName.Justice, 250, ref gainedPath))
				{
					if (gainedPath)
						m.SendLocalizedMessage(1049367); // You have gained a path in Justice!
					else
						m.SendLocalizedMessage(1049363); // You have gained in Justice.

                m.FixedParticles(0x375A, 9, 20, 5027, EffectLayer.Waist);
					m.PlaySound(0x1F7);
				}
			}
		}
	}
}