using System; 
using Server;
using Server.Items;
using System.Collections;
using System.Collections.Generic;

namespace Server.Mobiles 
{ 
	//[CorpseName( "an evil mage lord corpse" )] 
	public class EvilMageLord : BaseCreature 
	{ 
		public override WeaponAbility GetWeaponAbility()
		{
			switch ( Utility.Random( 3 ) )
			{
				default:
				case 0: return WeaponAbility.DoubleStrike;
				case 1: return WeaponAbility.WhirlwindAttack;
				case 2: return WeaponAbility.CrushingBlow;
			}
		}
      
      [Constructable] 
		public EvilMageLord() : base( AIType.AI_Necromage, FightMode.Closest, 10, 1, 0.2, 0.4 ) 
		{ 
			Name = NameList.RandomName( "evil mage lord" );
			Body = Utility.RandomList( 125, 126 );

			PackItem( new Robe( Utility.RandomMetalHue() ) ); 
			PackItem( new WizardsHat( Utility.RandomMetalHue() ) ); 

			SetStr( 81, 105 );
			SetDex( 191, 215 );
			SetInt( 326, 350 );

			SetHits( 309, 333 );

			SetDamage( 8, 13 );

			SetDamageType( ResistanceType.Physical, 40 );
			SetDamageType( ResistanceType.Cold, 20 );
			SetDamageType( ResistanceType.Energy, 40 );

			SetResistance( ResistanceType.Physical, 50, 55 );
			SetResistance( ResistanceType.Fire, 60, 75 );
			SetResistance( ResistanceType.Cold, 60, 75 );
			SetResistance( ResistanceType.Poison, 60, 75 );
			SetResistance( ResistanceType.Energy, 50, 60 );

			SetSkill( SkillName.EvalInt, 100.2, 120.0 );
			SetSkill( SkillName.Magery, 100.1, 120.0 );
			SetSkill( SkillName.Meditation, 27.5, 50.0 );
			SetSkill( SkillName.MagicResist, 77.5, 100.0 );
			SetSkill( SkillName.Tactics, 70.0, 96.5 );
			SetSkill( SkillName.Wrestling, 70.3, 90.0 );
			SetSkill( SkillName.Necromancy, 190.6, 220.5 );
			SetSkill( SkillName.SpiritSpeak, 90.1, 120.5 );

			Fame = 10500;
			Karma = -10500;

			VirtualArmor = 35;
			PackReg( 23 );
			if ( Utility.RandomBool() )
				PackItem( new Shoes() );
			else
				PackItem( new Sandals() );
		}

		public override void GenerateLoot()
		{
			AddLoot( LootPack.Rich, 2 );
			AddLoot( LootPack.MedScrolls, 2 );
		}

		public override bool CanRummageCorpses{ get{ return true; } }
		public override bool AlwaysMurderer{ get{ return true; } }
		public override int Meat{ get{ return 1; } }
		public override int TreasureMapLevel{ get{ return 2; } }
		public override bool IsNotScaredOfDeath{ get{ return true; } } //neutika pri malem poctu hp
		
		private static bool m_InHere;

		public override void OnDamage( int amount, Mobile from, bool willKill, int typ )
		{
			base.OnDamage( amount, from, willKill, typ );
			
			if ( from != null && from != this && !m_InHere )
			{
				m_InHere = true;

				if ( 0.1 > Utility.RandomDouble() )
				{
					Aura();
				}
				
				from.Stam -= Utility.Random( 2, 10 );
				from.Mana -= Utility.Random( 2, 5 );
				
				if ( from is PlayerMobile && !InRange( from.Location, 2 ) && Utility.RandomDouble() < 0.2 )
				{
					Point3D fromloc = from.Location;
					Point3D thisloc = this.Location;
					
               Combatant = from;
					from.MoveToWorld( thisloc, Map );
					this.MoveToWorld( fromloc, Map );
					from.FixedParticles( 0x376A, 9, 32, 0x13AF, EffectLayer.Waist );
					from.PlaySound( 0x1FE );
				}
				
				m_InHere = false;
			}
		}
		
      private void Aura()
      {
          ArrayList targets = Utilitky.GetTargets( this, 8, true );

          for (int i = 0; i < targets.Count; ++i)
          {
              Mobile m = (Mobile)targets[i];
              
              if ( m == null || m.Deleted )
                  continue;

              m.RevealingAction();
              this.DoHarmful(m);

              int auradamage = Utility.Random( 20, 50 );
              int scalebyrange;

              if (m.InRange(this.Location, 4))
                  scalebyrange = 1;
              else
                  scalebyrange = 2;

              auradamage /= scalebyrange;


// 		       Effects.SendLocationParticles( EffectItem.Create( m.Location, Map, EffectItem.DefaultDuration ), 0x36BD, 20, 10, 5044 );
// 		       Effects.PlaySound( m.Location, Map, 520 );
				 m.FixedParticles( 0x36BD, 20, 10, 5044, EffectLayer.Head );
				 m.PlaySound( 0x307 );
		       Effects.SendMovingEffect( this, m, 0x36D4, 5, 0, false, false );
		       
		       m.Hits -= auradamage;
		       ISTile5.SendDmgPacket( m, auradamage );
               if (m.Hits < 2)
                  m.Kill(); 
          }
      }
      
        public override void AlterMeleeDamageTo( Mobile to, ref int damage )
        {
            damage = DecreaseDamage( to, damage );
            
            if ( to is Xanthos.Interfaces.IEvoCreature )
        		  damage *= 5;
        }

		public EvilMageLord( Serial serial ) : base( serial ) 
		{ 
		} 

		public override void Serialize( GenericWriter writer ) 
		{ 
			base.Serialize( writer ); 
			writer.Write( (int) 0 ); 
		} 

		public override void Deserialize( GenericReader reader ) 
		{ 
			base.Deserialize( reader ); 
			int version = reader.ReadInt(); 
		} 
	} 
}