using System;
using System.Collections;
using Server.Items;
using Server.Targeting;

namespace Server.Mobiles
{
	//[CorpseName( "a bone warrior corpse" )]
	public class BoneWarrior : BaseCreature
	{
		[Constructable]
		public BoneWarrior() : base( AIType.AI_Melee, FightMode.Closest, 10, 1, 0.2, 0.4 )
		{
			Name = "a bone warrior";
			Body = 56;
			BaseSoundID = 451;
			Hue = Utility.RandomNeutralHue();

			SetStr( 256, 400 );
			SetDex( 80, 125 );
			SetInt( 36, 60 );

			SetHits( 318, 550 );

			SetDamage( 12, 28 );

			SetDamageType( ResistanceType.Physical, 40 );
			SetDamageType( ResistanceType.Cold, 60 );

			SetResistance( ResistanceType.Physical, 35, 65 );
			SetResistance( ResistanceType.Fire, 30, 40 );
			SetResistance( ResistanceType.Cold, 50, 60 );
			SetResistance( ResistanceType.Poison, 50, 60 );
			SetResistance( ResistanceType.Energy, 30, 40 );

			SetSkill( SkillName.MagicResist, 85.1, 90.0 );
			SetSkill( SkillName.Tactics, 95.1, 120.0 );
			SetSkill( SkillName.Wrestling, 95.1, 120.0 );
			SetSkill( SkillName.Parry, 40.1, 60.0 );
			SetSkill( SkillName.Anatomy, 50.1, 90.0 );
			
			Fame = 14000;
			Karma = -6000;

			VirtualArmor = 40;
			
          switch ( Utility.Random( 5 ))
          {
            case 0: PackItem( new BoneArms() ); break;
            case 1: PackItem( new BoneChest() ); break;
            case 2: PackItem( new BoneGloves() ); break;
            case 3: PackItem( new BoneLegs() ); break;
            case 4: PackItem( new BoneHelm() ); break;
          }

			PackItem( new Axe() );
			PackGem( 2 );
		}

		public override void GenerateLoot()
		{
			AddLoot( LootPack.FilthyRich, 2 );
		}

		public override bool BleedImmune{ get{ return true; } }
		public override Poison PoisonImmune{ get{ return Poison.Lethal; } }
		public override bool IsNotScaredOfDeath{ get{ return true; } } //neutika pri malem poctu hp
		
		public BoneWarrior( Serial serial ) : base( serial )
		{
		}

		public override OppositionGroup OppositionGroup
		{
			get{ return OppositionGroup.FeyAndUndead; }
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}