using System;
using System.Collections;
using Server.Items;
using Server.Targeting;

namespace Server.Mobiles
{
	//[CorpseName( "a bone warrior corpse" )]
	public class BoneWarriorArcher : BaseCreature
	{
		public override WeaponAbility GetWeaponAbility()
		{
			return WeaponAbility.DoubleStrike;
		}
      
      [Constructable]
		public BoneWarriorArcher() : base( AIType.AI_Archer, FightMode.Closest, 10, 1, 0.2, 0.4 )
		{
			Name = "a bone warrior archer";
			Body = 50;
			BaseSoundID = 451;
			Hue = Utility.RandomNeutralHue();

			SetStr( 256, 300 );
			SetDex( 100, 155 );
			SetInt( 36, 60 );

			SetHits( 218, 450 );

			SetDamage( 12, 28 );

			SetDamageType( ResistanceType.Physical, 40 );
			SetDamageType( ResistanceType.Cold, 60 );

			SetResistance( ResistanceType.Physical, 35, 65 );
			SetResistance( ResistanceType.Fire, 30, 40 );
			SetResistance( ResistanceType.Cold, 50, 60 );
			SetResistance( ResistanceType.Poison, 50, 60 );
			SetResistance( ResistanceType.Energy, 30, 40 );

			SetSkill( SkillName.MagicResist, 85.1, 90.0 );
			SetSkill( SkillName.Tactics, 95.1, 120.0 );
			SetSkill( SkillName.Archery, 95.1, 120.0 );
			SetSkill( SkillName.Anatomy, 80.1, 120.0 );
			
			Fame = 14000;
			Karma = -6000;

			VirtualArmor = 40;
			
          switch ( Utility.Random( 5 ))
          {
            case 0: PackItem( new BoneArms() ); break;
            case 1: PackItem( new BoneChest() ); break;
            case 2: PackItem( new BoneGloves() ); break;
            case 3: PackItem( new BoneLegs() ); break;
            case 4: PackItem( new BoneHelm() ); break;
          }

			PackItem( new Arrow( Utility.RandomMinMax( 2, 10 ) ) );
            
			AddItem( new Bow() );
		}

		public override void GenerateLoot()
		{
			AddLoot( LootPack.Average );
		}

		public override bool BleedImmune{ get{ return true; } }
		public override Poison PoisonImmune{ get{ return Poison.Lethal; } }
		public override bool IsNotScaredOfDeath{ get{ return true; } } //neutika pri malem poctu hp
		
		public BoneWarriorArcher( Serial serial ) : base( serial )
		{
		}

		public override OppositionGroup OppositionGroup
		{
			get{ return OppositionGroup.FeyAndUndead; }
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}