using System;
using System.Collections;
using Server.Items;
using Server.Targeting;

namespace Server.Mobiles
{
	//[CorpseName( "a bone warrior corpse" )]
	public class BoneWarriorMage : BaseCreature
	{
		[Constructable]
		public BoneWarriorMage() : base( AIType.AI_Necromage, FightMode.Closest, 10, 5, 0.2, 0.4 )
		{
			Name = "a bone warrior mage";
			Body = 50;
			BaseSoundID = 451;
			Hue = Utility.RandomNeutralHue();

			SetStr( 156, 200 );
			SetDex( 50, 85 );
			SetInt( 656, 760 );

			SetHits( 318, 450 );

			SetDamage( 12, 28 );

			SetDamageType( ResistanceType.Physical, 40 );
			SetDamageType( ResistanceType.Cold, 60 );

			SetResistance( ResistanceType.Physical, 35, 65 );
			SetResistance( ResistanceType.Fire, 30, 40 );
			SetResistance( ResistanceType.Cold, 50, 60 );
			SetResistance( ResistanceType.Poison, 50, 60 );
			SetResistance( ResistanceType.Energy, 30, 40 );

			SetSkill( SkillName.MagicResist, 85.1, 90.0 );
			SetSkill( SkillName.EvalInt, 77.6, 87.5 );
			SetSkill( SkillName.Necromancy, 190.6, 220.5 );
			SetSkill( SkillName.SpiritSpeak, 90.1, 120.5 );
			SetSkill( SkillName.Magery, 190.1, 200.1);
			SetSkill( SkillName.Poisoning, 80.5 );
			SetSkill( SkillName.Meditation, 110.0 );
			SetSkill( SkillName.Tactics, 95.1, 120.0 );
			SetSkill( SkillName.Wrestling, 95.1, 120.0 );

			Fame = 14000;
			Karma = -6000;

			VirtualArmor = 30;
			
          switch ( Utility.Random( 5 ))
          {
            case 0: PackItem( new BoneArms() ); break;
            case 1: PackItem( new BoneChest() ); break;
            case 2: PackItem( new BoneGloves() ); break;
            case 3: PackItem( new BoneLegs() ); break;
            case 4: PackItem( new BoneHelm() ); break;
          }

			PackNecroReg( 2, 5 );
			PackItem( Loot.RandomNecromancerScroll() );
		}

		public override void GenerateLoot()
		{
			AddLoot( LootPack.Average );
			AddLoot( LootPack.MedScrolls );
		}

		public override bool BleedImmune{ get{ return true; } }
		public override Poison PoisonImmune{ get{ return Poison.Lethal; } }
		public override bool IsNotScaredOfDeath{ get{ return true; } } //neutika pri malem poctu hp
		
		public BoneWarriorMage( Serial serial ) : base( serial )
		{
		}

		public override OppositionGroup OppositionGroup
		{
			get{ return OppositionGroup.FeyAndUndead; }
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}