using System;
using System.Collections;
using Server.Items;
using Server.Targeting;

namespace Server.Mobiles
{
	//[CorpseName( "a ghoul lord corpse" )]
	public class GhoulLord : BaseCreature
	{
		public override WeaponAbility GetWeaponAbility()
		{
			return Utility.RandomBool() ? WeaponAbility.MortalStrike : WeaponAbility.CrushingBlow;
		}

      [Constructable]
		public GhoulLord() : base( AIType.AI_Mage, FightMode.Closest, 10, 1, 0.2, 0.4 )
		{
			Name = "a Ghoul Lord";
			Body = 153;
			BaseSoundID = 0x482;
			Hue = 2220;

			SetStr( 276, 400 );
			SetDex( 76, 95 );
			SetInt( 836, 960 );

			SetHits( 460, 600 );
			SetMana( 500 );

			SetDamage( 5, 22 );

			SetDamageType( ResistanceType.Physical, 100 );

			SetResistance( ResistanceType.Physical, 70 );
			SetResistance( ResistanceType.Fire, 40, 60 );
			SetResistance( ResistanceType.Cold, 50, 60 );
			SetResistance( ResistanceType.Poison, 90 );
			SetResistance( ResistanceType.Energy, 40, 60 );

			SetSkill( SkillName.MagicResist, 80.1, 110.0 );
			SetSkill( SkillName.Tactics, 80.1, 110.0 );
			SetSkill( SkillName.Wrestling, 80.1, 120.0 );
			SetSkill( SkillName.EvalInt, 100.1, 120.1 );
			SetSkill( SkillName.Magery, 100.1, 120.1);
			SetSkill( SkillName.Poisoning, 80.5 );
			SetSkill( SkillName.Meditation, 110.0 );

			Fame = 14000;
			Karma = -5500;

			VirtualArmor = 38;

			PackItem( Loot.RandomWeapon() );
			PackNecroReg( 2, 8 );
         PackGem( 1 );
		}

		public override void GenerateLoot()
		{
			AddLoot( LootPack.Rich );
         
			if ( Utility.RandomDouble() < 0.3 )
			   AddLoot( LootPack.HighScrolls, 1 );
			   
			AddLoot( LootPack.MedScrolls, 2 );
		}

		public override bool BleedImmune{ get{ return true; } }
		public override Poison PoisonImmune{ get{ return Poison.Regular; } }
		public override int TreasureMapLevel{ get{ return 4; } }
		public override bool IsNotScaredOfDeath{ get{ return true; } } //neutika pri malem poctu hp
		public override bool BardImmune{ get{ return true; } }
		public override bool Unprovokable{ get{ return true; } }
		public override bool Uncalmable{ get{ return true; } }

		public GhoulLord( Serial serial ) : base( serial )
		{
		}

		public override OppositionGroup OppositionGroup
		{
			get{ return OppositionGroup.FeyAndUndead; }
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}