using System;
// using Server;
using System.Collections;
using Server.Items;
using Server.Targeting;

namespace Server.Mobiles
{
	//[CorpseName( "a mummy lord corpse" )]
	public class MummyLord : BaseCreature
	{
		public override WeaponAbility GetWeaponAbility()
		{
			return Utility.RandomBool() ? WeaponAbility.ConcussionBlow : WeaponAbility.CrushingBlow;
		}

      [Constructable]
		public MummyLord() : base( AIType.AI_Necromage, FightMode.Closest, 10, 1, 0.4, 0.8 )
		{
			Name = "a mummy lord";
			Body = 154;
			BaseSoundID = 471;
			Hue = Utility.RandomNeutralHue();

			SetStr( 446, 670 );
			SetDex( 71, 120 );
			SetInt( 926, 1040 );

			SetHits( 2908, 3122 );

			SetDamage( 13, 33 );

			SetDamageType( ResistanceType.Physical, 10 );
			SetDamageType( ResistanceType.Cold, 90 );

			SetResistance( ResistanceType.Physical, 50, 70 );
			SetResistance( ResistanceType.Fire, 30, 40 );
			SetResistance( ResistanceType.Cold, 50, 70 );
			SetResistance( ResistanceType.Poison, 50, 70 );
			SetResistance( ResistanceType.Energy, 50, 70 );

			SetSkill( SkillName.MagicResist, 85.1, 90.0 );
			SetSkill( SkillName.EvalInt, 77.6, 87.5 );
			SetSkill( SkillName.Necromancy, 190.6, 220.5 );
			SetSkill( SkillName.SpiritSpeak, 90.1, 120.5 );
			SetSkill( SkillName.Magery, 190.1, 220.1);
			SetSkill( SkillName.Poisoning, 80.5 );
			SetSkill( SkillName.Meditation, 110.0 );
			SetSkill( SkillName.Tactics, 95.1, 120.0 );
			SetSkill( SkillName.Wrestling, 95.1, 120.0 );
			SetSkill( SkillName.Anatomy, 50.1, 90.0 );

			Fame = 24000;
			Karma = -9000;

			VirtualArmor = 50;

			PackItem( new Garlic( 10 ) );
			PackItem( new EnhancedBandage( 30 ) );
			PackItem( new Bandage( 30 ) );
			PackItem( Loot.RandomNewPotion() );
			PackItem( Loot.RandomNecromancerScroll() );
// 			if ( Utility.RandomDouble() < 0.1 )				
// 				PackItem( new BloodwoodSpirit() );
		}

		public override void GenerateLoot()
		{
			AddLoot( LootPack.UltraRich );
			AddLoot( LootPack.Gems );
			AddLoot( LootPack.Potions );
		}
		
		public override bool AutoDispel{ get{ return true; } }
		public override bool BardImmune{ get{ return true; } }
		public override bool Unprovokable{ get{ return true; } }
		public override bool Uncalmable{ get{ return true; } }
		public override bool BleedImmune{ get{ return true; } }
		public override Poison PoisonImmune{ get{ return Poison.Greater; } }
		public override Poison HitPoison{ get{ return Poison.Greater; } } 
		public override int TreasureMapLevel{ get{ return 5; } }
		public override bool IsNotScaredOfDeath{ get{ return true; } } //neutika pri malem poctu hp
		
		public MummyLord( Serial serial ) : base( serial )
		{
		}

		public override OppositionGroup OppositionGroup
		{
			get{ return OppositionGroup.FeyAndUndead; }
		}
		
		public override void OnGotMeleeAttack( Mobile attacker )
		{
			base.OnGotMeleeAttack( attacker );
			attacker.Stam -= Utility.Random( 2, 6 );
			
			if ( Utility.RandomDouble() < 0.05 )
				Summon();
		}
		
		public override void OnDamagedBySpell( Mobile attacker )
		{
			base.OnDamagedBySpell( attacker );
			
			if ( Utility.RandomDouble() < 0.05 )
				Summon();
		}

		public void Summon()
		{
			Map map = this.Map;

			if ( map == null )
				return;

			int newSummon = Utility.RandomMinMax( 1, 4 );
			Say( 1075119 ); // Awake my children!  I summon thee!
			
			for ( int i = 0; i < newSummon; ++i )
			{
				Mobile summon = null;
				
				switch ( Utility.Random( 2 ) )
				{
					case 0: summon = new SumZombie(); break;
					case 1: summon = new SumMummy(); break;
				}

				bool validLocation = false;
				Point3D loc = this.Location;

				for ( int j = 0; !validLocation && j < 10; ++j )
				{
					int x = X + Utility.Random( 3 ) - 1;
					int y = Y + Utility.Random( 3 ) - 1;
					int z = map.GetAverageZ( x, y );

					if ( validLocation = map.CanFit( x, y, this.Z, 16, false, false ) )
						loc = new Point3D( x, y, Z );
					else if ( validLocation = map.CanFit( x, y, z, 16, false, false ) )
						loc = new Point3D( x, y, z );
				}
				
// 				summon.Team = this.Team;
				summon.MoveToWorld( loc, map );
				summon.Combatant = null;
			}
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}