/////////////////
///LostSinner///
///////////////
using System;
using Server;
using Server.Misc;
using Server.Items;

namespace Server.Mobiles 
{ 
	//[CorpseName( "a Vampire corpse" )] 
	public class VampireElder : BaseCreature 
	{ 
		[Constructable] 
		public VampireElder() : base( AIType.AI_Melee, FightMode.Closest, 10, 1, 0.2, 0.4 ) 
		{ 
			Title = "the Vampire";
			Name = NameList.RandomName( "male" );
			Body = 400;
			Hue = 0;  

			SetStr( 400, 600 );
			SetDex( 91, 115 );
			SetInt( 300, 320 );

			SetHits( 520, 725 );

			SetDamage( 15, 25 );

			SetDamageType( ResistanceType.Physical, 100 );

			SetResistance( ResistanceType.Physical, 50, 80 );
			SetResistance( ResistanceType.Fire, 20, 50 );
			SetResistance( ResistanceType.Poison, 50, 80 );
			SetResistance( ResistanceType.Energy, 50, 80 );

			SetSkill( SkillName.EvalInt, 85.0, 110.0 );
			SetSkill( SkillName.Tactics, 75.1, 110.0 );
			SetSkill( SkillName.MagicResist, 75.0, 107.5 );
			SetSkill( SkillName.Wrestling, 100.2, 115.0 );
			SetSkill( SkillName.Meditation, 120.0);
			SetSkill( SkillName.Focus, 120.0);
			SetSkill( SkillName.Fencing, 100.0, 115.0 );
			
			Fame = 3500;
			Karma = -9500;

			VirtualArmor = 50;

			Item hair = new Item( Utility.RandomList( 0x203B, 0x2049, 0x2048, 0x204A ) );
			hair.Hue = 1150;
			hair.Layer = Layer.Hair;
			hair.Movable = false;
			AddItem( hair );
			
   		AddItem( new Tunic() );
   		AddItem( new WizardsHat( 1175 ) );
   		AddItem( new LongPants( 1175 ) );
   		AddItem( new Boots( 33 ) );
   		AddItem( new Cloak( 33 ) );
   		AddItem( new Kryss() );
   		AddItem( new SilverNecklace() );
   		
			if ( 0.025 > Utility.RandomDouble() )
				AddItem( new SignOfAncientVampire() );
		}

		public override void GenerateLoot()
		{
			AddLoot( LootPack.FilthyRich, 2 );
			AddLoot( LootPack.Rich );
			AddLoot( LootPack.Gems, 5 );
		}
		
		public override WeaponAbility GetWeaponAbility()
		{
			return Utility.RandomBool() ? WeaponAbility.BleedAttack : WeaponAbility.MortalStrike;
		}
		
      public override void OnDamage(int amount, Mobile from, bool willKill, int typ)
      {
          if ( from == null )
            return;
            
          base.OnDamage( amount, from, willKill, typ );
          
          //promena
          if ( BodyValue != 754 && 15 > Utility.Random(100) )  //792 chaosdemon //317 vampik
          {
               BodyValue = 754;
               Name = "an elder vampire";
               Title = null;
               Heal( HitsMax );
               Hue = 1157;
               BaseSoundID = 0x174;
          }
          
          if ( !willKill && from != null && 4 > Utility.Random(100))//Blood Suck
          {
              if (from is BaseCreature)
              {
                  BaseCreature pet = (BaseCreature)from;

                  int lifeloss = (int)(  ( pet.Hits / 100 ) * 10 );

                  Point3D mobloc = new Point3D(pet.X, pet.Y, pet.Z);
                  Map mobmap = pet.Map;

                  Point3D thisloc = new Point3D(this.X, this.Y, this.Z);
                  Map thismap = this.Map;

                  Effects.SendLocationParticles(EffectItem.Create(mobloc, mobmap, EffectItem.DefaultDuration), 14154, 10, 10, 5023);
                  Effects.SendLocationParticles(EffectItem.Create(thisloc, thismap, EffectItem.DefaultDuration), 14154, 10, 10, 5023);

                  pet.Damage( lifeloss, this );
                  Heal( lifeloss );
                  Say( "*You see {0} drains life from {1}*", this.Name, pet.Name );
              }
              else if (from is PlayerMobile)
              {
                  PlayerMobile player = (PlayerMobile)from;

                  int lifeloss = (int)(  ( from.Hits / 100 ) * 20 );

                  Point3D mobloc = new Point3D(player.X, player.Y, player.Z);
                  Map mobmap = player.Map;

                  Point3D thisloc = new Point3D(this.X, this.Y, this.Z);
                  Map thismap = this.Map;

                  Effects.SendLocationParticles(EffectItem.Create(mobloc, mobmap, EffectItem.DefaultDuration), 14154, 10, 10, 5023);
                  Effects.SendLocationParticles(EffectItem.Create(thisloc, thismap, EffectItem.DefaultDuration), 14154, 10, 10, 5023);

                  player.Damage( lifeloss, this );
                  Heal( lifeloss );
                  Say( "*You see {0} drains life from {1}*", this.Name, player.Name );
              }
              else
              {
//                   lifeloss = (5 / from.Hits) * 100;// 20% of there hits
                  int lifeloss = (int)(  ( from.Hits / 100 ) * 20 );
                  Point3D mobloc = new Point3D(from.X, from.Y, from.Z);
                  Map mobmap = from.Map;

                  Point3D thisloc = new Point3D(this.X, this.Y, this.Z);
                  Map thismap = this.Map;

                  Effects.SendLocationParticles(EffectItem.Create(mobloc, mobmap, EffectItem.DefaultDuration), 14154, 10, 10, 5023);
                  Effects.SendLocationParticles(EffectItem.Create(thisloc, thismap, EffectItem.DefaultDuration), 14154, 10, 10, 5023);

                  from.Damage( lifeloss, this );
                  Heal( lifeloss );

                  if (from != null)
                  {
                     Say( "*You see {0} drains life from {1}*", this.Name, from.Name );
                  }
              }
          }
      }
        
		public override bool AlwaysMurderer{ get{ return true; } }
      public override bool BardImmune { get { return true; } }
      public override Poison PoisonImmune{ get{ return Poison.Deadly; } }
      public override bool ShowFameTitle{ get{ return false; } }
		public override int TreasureMapLevel{ get{ return 4; } }
		public override bool IsNotScaredOfDeath{ get{ return true; } } //neutika pri malem poctu hp
		
		public VampireElder( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}
