/////////////////
///LostSinner///
///////////////

using System;
using Server;
using System.Collections;
using Server.Misc;
using Server.Items;
using Server.Network;

namespace Server.Mobiles 
{ 
	//[CorpseName( "a Vampire Lord corpse" )] 
	public class VampireLord : BaseCreature 
	{ 
		private bool m_FieldActive;
		public bool FieldActive{ get{ return m_FieldActive; } }
		public bool CanUseField{ get{ return Hits >= HitsMax / 2; } } // TODO: an OSI bug prevents to verify this

// 		public override bool IsScaredOfScaryThings{ get{ return false; } }
		public override bool IsScaryToPets{ get{ return true; } }

		public override WeaponAbility GetWeaponAbility()
		{
			return Utility.RandomBool() ? WeaponAbility.BleedAttack : WeaponAbility.MortalStrike;
		}

		[Constructable] 
		public VampireLord() : base( AIType.AI_Necromage, FightMode.Closest, 10, 1, 0.2, 0.4 ) 
		{ 
			Title = "the Lord of Vampires";
			Name = NameList.RandomName( "evil mage" );
			Body = 400;
			Hue = 0;  

			SetStr( 900, 1200 );
			SetDex( 150, 180 );
			SetInt( 960, 1200 );

			SetHits( 1200, 1600 );

			SetDamage( 10, 12 );
			
			SetResistance( ResistanceType.Physical, 60, 80 );
			SetResistance( ResistanceType.Fire, 25 );
			SetResistance( ResistanceType.Poison, 60, 80 );
			SetResistance( ResistanceType.Energy, 60, 80 );
			SetResistance( ResistanceType.Cold, 60, 80 );

			SetSkill( SkillName.EvalInt, 150.0, 175.0 );
			SetSkill( SkillName.Tactics, 120.0, 145.0 );
			SetSkill( SkillName.MagicResist, 120.0, 145.0 );
			SetSkill( SkillName.Wrestling, 130.0, 155.0 );
			SetSkill( SkillName.Meditation, 120.0, 155.0 );
			SetSkill( SkillName.Focus, 120.0, 155.0 );
			SetSkill( SkillName.Magery, 150.0, 275.0 );
			SetSkill( SkillName.Necromancy, 150.0, 175.0 );
			SetSkill( SkillName.SpiritSpeak, 150.0, 175.0 );
			
			Fame = -15000;
			Karma = -25000;

			VirtualArmor = 10;
						
			Item hair = new Item( Utility.RandomList( 0x203B, 0x2049, 0x2048, 0x204A ) );
			hair.Hue = 1150;
			hair.Layer = Layer.Hair;
			hair.Movable = false;
			AddItem( hair );
			
   		AddItem( new Tunic() );
   		AddItem( new WizardsHat( 1175 ) );
   		AddItem( new LongPants( 1175 ) );
   		AddItem( new Boots( 33 ) );
   		AddItem( new Cloak( 33 ) );
   		AddItem( new Kryss() );
   		AddItem( new SilverNecklace() );

			m_FieldActive = CanUseField;
			
			if ( 0.4 >= Utility.RandomDouble() )
				AddItem( new SignOfAncientVampire() );
		}
		
		public override void GenerateLoot()
		{
			AddLoot( LootPack.SuperBoss, 1 );
			PackNecroReg( 62, 80 );
			AddLoot( LootPack.Gems, 5 );
         PackGold( 5000 );
		}

		public override bool CanRummageCorpses{ get{ return true; } }
		public override bool BardImmune{ get{ return true; } }
		public override bool Unprovokable{ get{ return true; } }
		public override bool Uncalmable{ get{ return true; } }
		public override Poison PoisonImmune{ get{ return Poison.Lethal; } }
		public override bool AlwaysMurderer{ get{ return true; } }

		public override void AlterMeleeDamageFrom( Mobile from, ref int damage )
		{
			if ( m_FieldActive )
				damage = 0; // no melee damage when the field is up
		}

		public override void AlterSpellDamageFrom( Mobile from, ref int damage )
		{
			if ( !m_FieldActive )
				damage = 0; // no spell damage when the field is down
		}

      public override void OnDamage(int amount, Mobile from, bool willKill, int typ)
      {
          //promena
          if ( this.BodyValue != 792 && 5 > Utility.Random(100) )  //792 chaosdemon //317 vampik
          {
               this.BodyValue = 792;
               this.Hits = this.HitsMax;
               this.Hue = 1157;
               this.BaseSoundID = 0x47D;
          }
      }

		public override void OnDamagedBySpell( Mobile from )
		{
			if( from != null && from.Alive && 0.4 > Utility.RandomDouble() )
			{
				SendEBolt( from );
			}

			if ( !m_FieldActive )
			{
				// should there be an effect when spells nullifying is on?
				this.FixedParticles( 0, 10, 0, 0x2522, EffectLayer.Waist );
			}
			else if ( m_FieldActive && !CanUseField )
			{
				m_FieldActive = false;

				// TODO: message and effect when field turns down; cannot be verified on OSI due to a bug
				this.FixedParticles( 0x3735, 1, 30, 0x251F, EffectLayer.Waist );
			}
		}

		public override void OnGotMeleeAttack( Mobile attacker )
		{
			base.OnGotMeleeAttack( attacker );

			if ( m_FieldActive )
			{
				this.FixedParticles( 0x376A, 20, 10, 0x2530, EffectLayer.Waist );

				PlaySound( 0x2F4 );

				attacker.SendAsciiMessage( "Muahahaha! Do you really think you could hurt me!" );
			}

			if( attacker != null && attacker.Alive && attacker.Weapon is BaseRanged && 0.4 > Utility.RandomDouble() )
			{
				SendEBolt( attacker );
			}
		}

		public override void OnThink()
		{
			base.OnThink();

			// TODO: an OSI bug prevents to verify if the field can regenerate or not
			if ( !m_FieldActive && CanUseField )
				m_FieldActive = true;
		}

		public override bool Move( Direction d )
		{
			bool move = base.Move( d );

			if ( move && m_FieldActive && this.Combatant != null )
				this.FixedParticles( 0, 0, 0, 5033, EffectLayer.Waist );

			return move;
		}

		public void SendEBolt( Mobile to )
		{
			this.MovingParticles( to, 0x379F, 7, 0, false, true, 0xBE3, 0xFCB, 0x211 );
			to.PlaySound( 0x229 );
			this.DoHarmful( to );
			AOS.Damage( to, this, 50, 0, 0, 0, 0, 100 );
		}
		public void DrainLife()
		{
			ArrayList list = new ArrayList();

			foreach ( Mobile m in this.GetMobilesInRange( 10 ) )
			{
				if ( m == this || !CanBeHarmful( m ) )
					continue;

				if ( m is BaseCreature && (((BaseCreature)m).Controlled || ((BaseCreature)m).Summoned || ((BaseCreature)m).Team != this.Team) )
					list.Add( m );
				if ( m is BaseCreature )
					list.Add( m );
				else if ( m.Player )
					list.Add( m );
			}

			foreach ( Mobile m in list )
			{
				DoHarmful( m );

				Say( "Your soul belongs to me!" );
				FixedParticles( 0x3709, 10, 30, 5052, EffectLayer.LeftFoot );

				m.FixedParticles( 0x3709, 1, 30, 9965, 5, 7, EffectLayer.Waist );
				m.FixedParticles( 0x376A, 1, 30, 9502, 5, 3, EffectLayer.Waist );
				m.PlaySound( 0x231 );

				m.SendMessage( "You feel your soul being pulled from your body!" );

				int toDrain = Utility.RandomMinMax( 30, 35 );

				Hits += toDrain;
				m.Damage( toDrain, this );
			}
		}
		public override void OnGaveMeleeAttack( Mobile attacker )
		{
			base.OnGotMeleeAttack( attacker );

			if ( 0.33>= Utility.RandomDouble() )
				DrainLife();
		}
	
		public VampireLord( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}

