/////////////////
///LostSinner///
///////////////
using System;
using Server;
using Server.Misc;
using Server.Items;

namespace Server.Mobiles 
{ 
	//[CorpseName( "a Vampire corpse" )] 
	public class VampireYoung : BaseCreature 
	{ 
		[Constructable] 
		public VampireYoung() : base( AIType.AI_Melee, FightMode.Closest, 10, 1, 0.2, 0.4 ) 
		{ 
			Title = "the Vampire";
			Name = NameList.RandomName( "male" );
			Body = 400;
			Hue = 0;  

			SetStr( 200, 400 );
			SetDex( 91, 115 );
			SetInt( 300, 320 );

			SetHits( 320, 525 );

			SetDamage( 10, 15 );

			SetDamageType( ResistanceType.Physical, 100 );

			SetResistance( ResistanceType.Physical, 40, 60 );
			SetResistance( ResistanceType.Fire, 10, 40 );
			SetResistance( ResistanceType.Poison, 40, 60 );
			SetResistance( ResistanceType.Energy, 40, 60 );

			SetSkill( SkillName.EvalInt, 85.0, 90.0 );
			SetSkill( SkillName.Tactics, 75.1, 90.0 );
			SetSkill( SkillName.MagicResist, 75.0, 97.5 );
			SetSkill( SkillName.Wrestling, 70.2, 95.0 );
			SetSkill( SkillName.Meditation, 120.0);
			SetSkill( SkillName.Focus, 120.0);
			SetSkill( SkillName.Fencing, 70.0, 90.0 );
			
			Fame = 2500;
			Karma = -7500;

			VirtualArmor = 40;

			Item hair = new Item( Utility.RandomList( 0x203B, 0x2049, 0x2048, 0x204A ) );
			hair.Hue = 1150;
			hair.Layer = Layer.Hair;
			hair.Movable = false;
			AddItem( hair );
			
   		AddItem( new Tunic() );
   		AddItem( new WizardsHat( 1175 ) );
   		AddItem( new LongPants( 1175 ) );
   		AddItem( new Boots( 33 ) );
   		AddItem( new Cloak( 33 ) );
   		AddItem( new Kryss() );
   		AddItem( new SilverNecklace() );
		}

		public override void GenerateLoot()
		{
			AddLoot( LootPack.Rich );
			AddLoot( LootPack.Average );
			AddLoot( LootPack.Gems, 2 );
		}
		
		public override WeaponAbility GetWeaponAbility()
		{
			return WeaponAbility.BleedAttack;
		}
		
      public override void OnDamage(int amount, Mobile from, bool willKill, int typ)
      {
          //promena
          if ( this.BodyValue != 317 && 10 > Utility.Random(100) )  //792 chaosdemon //317 vampik
          {
               this.BodyValue = 317;
               this.Name = "an Young vampire";
               this.Title = null;
               this.Heal( this.HitsMax );
               this.Hue = 1157;
               this.BaseSoundID = 0x270;
          }
          
          if ( !willKill && from != null && 4 > Utility.Random(100))//Blood Suck
          {
              if (from is BaseCreature)
              {
                  BaseCreature pet = (BaseCreature)from;

                  int lifeloss = (int)(  ( pet.Hits / 100 ) * 5 );

                  Point3D mobloc = new Point3D(pet.X, pet.Y, pet.Z);
                  Map mobmap = pet.Map;

                  Point3D thisloc = new Point3D(this.X, this.Y, this.Z);
                  Map thismap = this.Map;

                  Effects.SendLocationParticles(EffectItem.Create(mobloc, mobmap, EffectItem.DefaultDuration), 14154, 10, 10, 5023);
                  Effects.SendLocationParticles(EffectItem.Create(thisloc, thismap, EffectItem.DefaultDuration), 14154, 10, 10, 5023);

                  pet.Damage( lifeloss, this );
                  this.Heal( lifeloss );
                  this.Say( "*You see {0} drains life from {1}*", this.Name, pet.Name );
              }
              else if (from is PlayerMobile)
              {
                  PlayerMobile player = (PlayerMobile)from;

                  int lifeloss = (int)(  ( from.Hits / 100 ) * 12 );

                  Point3D mobloc = new Point3D(player.X, player.Y, player.Z);
                  Map mobmap = player.Map;

                  Point3D thisloc = new Point3D(this.X, this.Y, this.Z);
                  Map thismap = this.Map;

                  Effects.SendLocationParticles(EffectItem.Create(mobloc, mobmap, EffectItem.DefaultDuration), 14154, 10, 10, 5023);
                  Effects.SendLocationParticles(EffectItem.Create(thisloc, thismap, EffectItem.DefaultDuration), 14154, 10, 10, 5023);

                  player.Damage( lifeloss, this );
                  this.Heal( lifeloss );
                  this.Say( "*You see {0} drains life from {1}*", this.Name, player.Name );
              }
              else
              {
//                   lifeloss = (5 / from.Hits) * 100;// 20% of there hits
                  int lifeloss = (int)(  ( from.Hits / 100 ) * 12 );
                  Point3D mobloc = new Point3D(from.X, from.Y, from.Z);
                  Map mobmap = from.Map;

                  Point3D thisloc = new Point3D(this.X, this.Y, this.Z);
                  Map thismap = this.Map;

                  Effects.SendLocationParticles(EffectItem.Create(mobloc, mobmap, EffectItem.DefaultDuration), 14154, 10, 10, 5023);
                  Effects.SendLocationParticles(EffectItem.Create(thisloc, thismap, EffectItem.DefaultDuration), 14154, 10, 10, 5023);

                  from.Damage( lifeloss, this );
                  this.Heal( lifeloss );

                  if (from != null)
                  {
                     this.Say( "*You see {0} drains life from {1}*", this.Name, from.Name );
                  }
              }
          }
      }
        
		public override bool AlwaysMurderer{ get{ return true; } }
      public override bool BardImmune { get { return true; } }
      public override Poison PoisonImmune{ get{ return Poison.Deadly; } }
      public override bool ShowFameTitle{ get{ return false; } }

		public VampireYoung( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}
