using System;
using System.Collections;
using Server.Items;
using Server.Targeting;
using Server.Network;

namespace Server.Mobiles
{
	//[CorpseName( "a walking dead corpse" )]
	public class WalkingDead : BaseCreature
	{
		[Constructable]
		public WalkingDead() : base( AIType.AI_Melee, FightMode.Closest, 10, 1, 0.2, 0.4 )
		{
			Name = "a walking dead";
			Body = 155;
			BaseSoundID = 471;
			Hue = 840;

			SetStr( 301, 650 );
			SetDex( 85 );
			SetInt( 50, 60 );

			SetHits( 1200, 2000 );
			SetStam( 150 );
			SetMana( 0 );

			SetDamage( 12, 20 );

			SetDamageType( ResistanceType.Physical, 0 );
			SetDamageType( ResistanceType.Cold, 30 );
			SetDamageType( ResistanceType.Poison, 70 );

			SetResistance( ResistanceType.Physical, 40, 50 );
			SetResistance( ResistanceType.Fire, 20, 30 );
			SetResistance( ResistanceType.Cold, 50, 70 );
			SetResistance( ResistanceType.Poison, 40, 50 );
			SetResistance( ResistanceType.Energy, 40, 50 );

			SetSkill( SkillName.Poisoning, 120.0 );
			SetSkill( SkillName.MagicResist, 250.0 );
			SetSkill( SkillName.Tactics, 110.0 );
			SetSkill( SkillName.Wrestling, 90.1, 120.0 );
			SetSkill( SkillName.Anatomy, 80.1, 120.0 );

			Fame = 20000;
			Karma = -9000;

			VirtualArmor = 40;
		}

		public override void GenerateLoot()
		{
			AddLoot( LootPack.UltraRich );
		}
		
		public override bool BardImmune{ get{ return true; } }
		public override bool Unprovokable{ get{ return true; } }
		public override bool Uncalmable{ get{ return true; } }
		public override bool BleedImmune{ get{ return true; } }
		public override Poison PoisonImmune{ get{ return Poison.Lethal; } }
		public override Poison HitPoison{ get{ return Poison.Lethal; } }
		public override int TreasureMapLevel{ get{ return 5; } }
		public override bool IsNotScaredOfDeath{ get{ return true; } } //neutika pri malem poctu hp
		
		public override bool OnBeforeDeath()
		{
// 			PublicOverheadMessage( MessageType.Regular, 0x3B2, true, "* Z nehybneho tela vyteka zeleny hnilobny sliz! *" );
         SpillAcid( TimeSpan.FromSeconds( 10 ), 30, 40, 3, 5 );
			return base.OnBeforeDeath();
		}
      
      public WalkingDead( Serial serial ) : base( serial )
		{
		}

		public override OppositionGroup OppositionGroup
		{
			get{ return OppositionGroup.FeyAndUndead; }
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}