using System;
using System.Collections;
using Server.Items;
using Server.Targeting;

namespace Server.Mobiles
{
	//[CorpseName( "a centaur archer corpse" )]
	public class CentaurArcher : BaseCreature
	{
		public override WeaponAbility GetWeaponAbility()
		{
			switch ( Utility.Random( 3 ) )
			{
				default:
					case 0: return WeaponAbility.LightningArrow;
					case 1: return WeaponAbility.ForceArrow;
					case 2: return WeaponAbility.SerpentArrow;
			}
		}
      
      [Constructable]
		public CentaurArcher() : base( AIType.AI_Archer, FightMode.Closest, 10, 1, 0.13, 0.30 )
		{
			Name = NameList.RandomName( "centaur" );
			Title = "the Centaur";
			Body = 101;
			BaseSoundID = 679;

			SetStr( 582, 600 );
			SetDex( 104, 260 );
			SetInt( 91, 100 );

			SetHits( 430, 472 );

			SetDamage( 13, 24 );

			SetDamageType( ResistanceType.Physical, 100 );

			SetResistance( ResistanceType.Physical, 40, 50 );
			SetResistance( ResistanceType.Fire, 40, 50 );
			SetResistance( ResistanceType.Cold, 40, 50 );
			SetResistance( ResistanceType.Poison, 40, 50 );
			SetResistance( ResistanceType.Energy, 40, 50 );

			SetSkill( SkillName.Anatomy, 95.1, 115.0 );
			SetSkill( SkillName.Archery, 95.1, 120.0 );
			SetSkill( SkillName.MagicResist, 50.3, 80.0 );
			SetSkill( SkillName.Tactics, 90.1, 120.0 );
			SetSkill( SkillName.Wrestling, 95.1, 120.0 );

			Fame = 15500;
			Karma = 0;

			VirtualArmor = 50;
			AddItem( new Bow() );
			PackItem( new Arrow( Utility.RandomMinMax( 10, 40 ) ) ); // OSI it is different: in a sub backpack, this is probably just a limitation of their engine
			
         if (Utility.RandomDouble() < 0.05)
				PackItem( new RandomTalisman() );
      }
      
		public override void OnDeath( Container c )
		{
			base.OnDeath( c );			
			PackRunicTool( c, 0.01, typeof( RunicSp ) );
		}

		public override void GenerateLoot()
		{
			AddLoot( LootPack.FilthyRich );
			AddLoot( LootPack.Rich );
			AddLoot( LootPack.Gems );
		}

		public override OppositionGroup OppositionGroup
		{
			get{ return OppositionGroup.FeyAndUndead; }
		}

		public override int Meat{ get{ return 1; } }
		public override int Hides{ get{ return 8; } }
		public override HideType HideType{ get{ return HideType.Spined; } }
		public override bool IsNotScaredOfDeath{ get{ return true; } } //neutika pri malem poctu hp
		public override int TreasureMapLevel{ get{ return 4; } }
		public override bool CanRummageCorpses{ get{ return true; } }
		public override bool Unprovokable{ get{ return true; } }
		public override bool BardImmune{ get{ return true; } }
		
		public CentaurArcher( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();

			if ( BaseSoundID == 678 )
				BaseSoundID = 679;
		}
	}
}