using System;
using Server.Items;
using Server.Network;
using Server.Items.MusicBox;

namespace Server.Mobiles
{
	//[CorpseName( "a golem corpse" )]
	public class Golem : BaseCreature
	{
		private bool m_Stunning;

		public override bool IsScaredOfScaryThings{ get{ return false; } }
		public override bool IsScaryToPets{ get{ return true; } }

		public override bool IsBondable{ get{ return false; } }

		[Constructable]
		public Golem() : this( false, 1.0 )
		{
		}

		[Constructable]
		public Golem( bool summoned, double scalar ) : base( AIType.AI_Melee, FightMode.Closest, 10, 1, 0.3, 0.5 )
		{
			Name = "a golem";
			Body = 752;

			if ( summoned )
			{
            Hue = 2101;
    			SetStr( (int)(700*scalar), (int)(800*scalar) );
    			SetDex( (int)(250*scalar), (int)(270*scalar) );
    			SetInt( (int)(301*scalar), (int)(311*scalar) );
    
    			SetHits( (int)(800*scalar), (int)(900*scalar) );
    
    			SetDamage( (int)(16*scalar), (int)(25*scalar) );
    
    			SetDamageType( ResistanceType.Physical, 100 );
    
    			SetResistance( ResistanceType.Physical, (int)(60*scalar), (int)(70*scalar) );    
    			SetResistance( ResistanceType.Fire, (int)(50*scalar), (int)(60*scalar) );    
    			SetResistance( ResistanceType.Cold, (int)(20*scalar), (int)(30*scalar) );
    			SetResistance( ResistanceType.Poison, 100 );
    			SetResistance( ResistanceType.Energy, (int)(50*scalar), (int)(60*scalar) );
    
    			SetSkill( SkillName.MagicResist, (150.1*scalar), (190.0*scalar) );
    			SetSkill( SkillName.Tactics, (90.1*scalar), (100.0*scalar) );
    			SetSkill( SkillName.Wrestling, (90.1*scalar), (100.0*scalar) );
			   SetSkill( SkillName.Anatomy, (45.1*scalar), (50.0*scalar) );
			   
				Fame = 10;
				Karma = 10;
         }
         else
         {
    			SetStr( 251, 350 );
    			SetDex( 76, 100 );
    			SetInt( 101, 150 );
    
    			SetHits( 151, 210 );
    
    			SetDamage( 13, 24 );
    
    			SetDamageType( ResistanceType.Physical, 100 );
    
    			SetResistance( ResistanceType.Physical, 35, 55 );    
    			SetResistance( ResistanceType.Fire, 100 );    
    			SetResistance( ResistanceType.Cold, 10, 30 );
    			SetResistance( ResistanceType.Poison, 10, 25 );
    			SetResistance( ResistanceType.Energy, 30, 40 );
    
    			SetSkill( SkillName.MagicResist, 150.1, 190.0 );
    			SetSkill( SkillName.Tactics, 60.1, 100.0 );
    			SetSkill( SkillName.Wrestling, 60.1, 100.0 );
    			
				Fame = 3500;
				Karma = -3500;
         }

			if ( !summoned )
			{
				PackItem( new IronIngot( Utility.RandomMinMax( 13, 21 ) ) );

				if ( 0.1 > Utility.RandomDouble() )
					PackItem( new PowerCrystal() );

				if ( 0.15 > Utility.RandomDouble() )
					PackItem( new ClockworkAssembly() );

				if ( 0.2 > Utility.RandomDouble() )
					PackItem( new ArcaneGem() );

				if ( 0.25 > Utility.RandomDouble() )
					PackItem( new Gears() );
			}

			ControlSlots = 3;
		}
		
		#region mod by Dies Irae
		public override void OnDeath( Container c )
		{
			base.OnDeath( c );		
			
			if( !Summoned && Utility.RandomDouble() < 0.05 )
			{
				if( IsParagon )
					c.DropItem( MusicBoxGears.RandomMusixBoxGears( TrackRarity.Rare ) );
				else
				{
					if( Utility.RandomBool() )
						c.DropItem( MusicBoxGears.RandomMusixBoxGears( TrackRarity.Common ) );
					else
						c.DropItem( MusicBoxGears.RandomMusixBoxGears( TrackRarity.UnCommon ) );
				}
			}
		}
		#endregion

		public override bool DeleteOnRelease{ get{ return true; } }

		public override int GetAngerSound()
		{
			return 541;
		}

		public override int GetIdleSound()
		{
			if ( !Controlled )
				return 542;

			return base.GetIdleSound();
		}

		public override int GetDeathSound()
		{
			if ( !Controlled )
				return 545;

			return base.GetDeathSound();
		}

		public override int GetAttackSound()
		{
			return 562;
		}

		public override int GetHurtSound()
		{
			if ( Controlled )
				return 320;

			return base.GetHurtSound();
		}

		public override bool AutoDispel{ get{ return !Controlled; } }
		public override bool BleedImmune{ get{ return true; } }

		public override void OnGaveMeleeAttack( Mobile defender )
		{
			base.OnGaveMeleeAttack( defender );

			if ( !m_Stunning && 0.3 > Utility.RandomDouble() )
			{
				m_Stunning = true;

				defender.Animate( 21, 6, 1, true, false, 0 );
				this.PlaySound( 0xEE );
				defender.LocalOverheadMessage( MessageType.Regular, 0x3B2, false, "You have been stunned by a colossal blow!" );

				BaseWeapon weapon = this.Weapon as BaseWeapon;
				if ( weapon != null )
					weapon.OnHit( this, defender );

				if ( defender.Alive )
				{
					defender.Frozen = true;
					Timer.DelayCall( TimeSpan.FromSeconds( 5.0 ), new TimerStateCallback( Recover_Callback ), defender );
				}
			}
		}

		private void Recover_Callback( object state )
		{
			Mobile defender = state as Mobile;

			if ( defender != null )
			{
				defender.Frozen = false;
				defender.Combatant = null;
				defender.LocalOverheadMessage( MessageType.Regular, 0x3B2, false, "You recover your senses." );
			}

			m_Stunning = false;
		}

		public override void OnDamage( int amount, Mobile from, bool willKill, int typ )
		{
			if ( Controlled || Summoned )
			{
				Mobile master = ( this.ControlMaster );

				if ( master == null )
					master = this.SummonMaster;

				if ( master != null && master.Player && master.Map == this.Map && master.InRange( Location, 20 ) )
				{
					int amnt = ( amount / 5 );
					
               if ( master.Mana >= amnt )
					{
						master.Mana -= amnt;
					}
					else
					{
						amnt -= master.Mana;
						master.Mana = 0;
						master.Damage( amnt );
					}
				}
			}

			base.OnDamage( amount, from, willKill, typ );
		}

		public override bool BardImmune{ get{ return true; } }
		public override Poison PoisonImmune{ get{ return Poison.Lethal; } }

		public Golem( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}