using System;
using Server;
using Server.Items;
using Xanthos.Evo;

namespace Server.Mobiles
{
	//[CorpseName( "a skeletal dragon corpse" )]
	public class SkeletalDragon : BaseCreature
	{
        private DateTime m_Delay = DateTime.Now;

        public override WeaponAbility GetWeaponAbility()
        {
            switch (Utility.Random(3))
            {
                default:
                case 0: return WeaponAbility.DoubleStrike;
                case 1: return WeaponAbility.WhirlwindAttack;
                case 2: return WeaponAbility.CrushingBlow;
            }
        }

        [Constructable]
		public SkeletalDragon () : base( AIType.AI_Mage, FightMode.Closest, 10, 1, 0.2, 0.4 )
		{
			Name = "a skeletal dragon";
			Body = 104;
			BaseSoundID = 0x488;

			SetStr( 998, 1030 );
			SetDex( 188, 200 );
			SetInt( 588, 620 );

			SetHits( 1000, 1250 );

			SetDamage( 29, 35 );

			SetDamageType( ResistanceType.Physical, 75 );
			SetDamageType( ResistanceType.Fire, 25 );

			SetResistance( ResistanceType.Physical, 75, 80 );
			SetResistance( ResistanceType.Fire, 60, 70 );
			SetResistance( ResistanceType.Cold, 60, 70);
			SetResistance( ResistanceType.Poison, 70, 80 );
			SetResistance( ResistanceType.Energy, 60, 70);

			SetSkill( SkillName.EvalInt, 90.1, 100.0 );
			SetSkill( SkillName.Magery, 90.1, 100.0 );
			SetSkill( SkillName.MagicResist, 120.3, 130.0 );
			SetSkill( SkillName.Tactics, 97.6, 120.0 );
			SetSkill( SkillName.Wrestling, 97.6, 120.0 );

			Fame = 22500;
			Karma = -22500;

			VirtualArmor = 80;
			PackItem( new RaelisDragonDust( Utility.RandomMinMax(5,30) ) );
		}
		
		public override void OnDeath( Container c )
		{
			base.OnDeath( c );			
			PackRunicTool( c, 0.01, typeof( RunicDr ) );
		}

		public override void GenerateLoot()
		{
			AddLoot( LootPack.FilthyRich, 2 );
			AddLoot( LootPack.Gems, 5 );
		}

		public override bool ReacquireOnMovement{ get{ return true; } }
		public override bool HasBreath{ get{ return true; } } // fire breath enabled
		public override int BreathFireDamage{ get{ return 0; } }
		public override int BreathColdDamage{ get{ return 100; } }
		public override int BreathEffectHue{ get{ return 0x480; } }
		public override double BonusPetDamageScalar{ get{ return (Core.SE)? 3.0 : 1.0; } }
		// TODO: Undead summoning?

		public override bool AutoDispel{ get{ return true; } }
		public override Poison PoisonImmune{ get{ return Poison.Lethal; } }
		public override bool BleedImmune{ get{ return true; } }
		public override int Meat{ get{ return 19; } } // where's it hiding these? :)
		public override int Hides{ get{ return 20; } }
		public override HideType HideType{ get{ return ( this.IsTeragon ) ? HideType.Dragon : HideType.Barbed; } }
		public override bool IsNotScaredOfDeath{ get{ return true; } } //neutika pri malem poctu hp
        public override bool Unprovokable { get { return true; } }

        public override void OnDamage(int amount, Mobile from, bool willKill, int typ)
        {
            base.OnDamage(amount, from, willKill, typ);

            if (DateTime.Now > m_Delay && typ == 0 && this.Hits < this.HitsMax / 2)
            {
                m_Delay = DateTime.Now + TimeSpan.FromMinutes(5.0);
                Effects.PlaySound(this.Location, this.Map, 0x491);

                ItemSummoningRing(5,this, typeof(UnholyBone), 0, null, Utility.Random(0xECA, 9));
                ItemSummoningRing(6, this, typeof(UnholyBone), 0, null, Utility.Random(0xECA, 9));
            }
        }

        #region Effects
        private static readonly double[] m_Offsets = new double[]
        {
            Math.Cos(000.0 / 180.0 * Math.PI), Math.Sin(000.0 / 180.0 * Math.PI),
            Math.Cos(040.0 / 180.0 * Math.PI), Math.Sin(040.0 / 180.0 * Math.PI),
            Math.Cos(080.0 / 180.0 * Math.PI), Math.Sin(080.0 / 180.0 * Math.PI),
            Math.Cos(120.0 / 180.0 * Math.PI), Math.Sin(120.0 / 180.0 * Math.PI),
            Math.Cos(160.0 / 180.0 * Math.PI), Math.Sin(160.0 / 180.0 * Math.PI),
            Math.Cos(200.0 / 180.0 * Math.PI), Math.Sin(200.0 / 180.0 * Math.PI),
            Math.Cos(240.0 / 180.0 * Math.PI), Math.Sin(240.0 / 180.0 * Math.PI),
            Math.Cos(280.0 / 180.0 * Math.PI), Math.Sin(280.0 / 180.0 * Math.PI),
            Math.Cos(320.0 / 180.0 * Math.PI), Math.Sin(320.0 / 180.0 * Math.PI),
        };

        public static void ItemSummoningRing(int range, Mobile summoner, Type item, int hue, string name, int itemid)
        {
            Map map = summoner.Map;

            if (map != null)
            {
                summoner.PlaySound(0x491);

                if (range < 3)
                    range = 3;

                for (int i = 0; i < m_Offsets.Length; i += 2)
                {
                    double rx = m_Offsets[i];
                    double ry = m_Offsets[i + 1];

                    int dist = 0;
                    bool ok = false;
                    int x = 0, y = 0, z = 0;

                    while (!ok && dist < range)
                    {
                        int rdist = range + dist;

                        x = summoner.X + (int)(rx * rdist);
                        y = summoner.Y + (int)(ry * rdist);
                        z = map.GetAverageZ(x, y);

                        if (!(ok = map.CanFit(x, y, summoner.Z, 16, false, false)))
                            ok = map.CanFit(x, y, z, 16, false, false);

                        if (ok && !summoner.InLOS(new Point3D(x, y, z)))
                            ok = false;

                        if (dist >= 0)
                            dist = -(dist + 1);
                        else
                            dist = -(dist - 1);
                    }

                    if (!ok)
                        continue;

                    Item spawnedItem = Activator.CreateInstance(item) as Item;

                    if (spawnedItem == null)
                        continue;

                    spawnedItem.Hue = hue;
                    spawnedItem.Name = name;
                    spawnedItem.ItemID = itemid;
                    spawnedItem.MoveToWorld(new Point3D(x, y, z), map);

                    summoner.MovingEffect(spawnedItem, spawnedItem.ItemID, 5, 1, false, false, spawnedItem.Hue, 0);
                }
            }
        }
        #endregion

        public SkeletalDragon( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}