using System;
using System.Collections;
using Server.Items;
using Server.Targeting;

namespace Server.Mobiles
{
	//[CorpseName( "a krakens corpse" )]
	public class Kraken : BaseCreature
	{
		[Constructable]
		public Kraken() : base( AIType.AI_Melee, FightMode.Closest, 10, 1, 0.2, 0.4 )
		{
			Name = "a kraken";
			Body = 77;
			BaseSoundID = 353;

			SetStr( 756, 780 );
			SetDex( 226, 245 );
			SetInt( 26, 40 );

			SetHits( 454, 468 );
			SetMana( 0 );

			SetDamage( 19, 33 );

			SetDamageType( ResistanceType.Physical, 70 );
			SetDamageType( ResistanceType.Cold, 30 );

			SetResistance( ResistanceType.Physical, 45, 55 );
			SetResistance( ResistanceType.Fire, 30, 40 );
			SetResistance( ResistanceType.Cold, 30, 40 );
			SetResistance( ResistanceType.Poison, 20, 30 );
			SetResistance( ResistanceType.Energy, 10, 20 );

			SetSkill( SkillName.MagicResist, 15.1, 20.0 );
			SetSkill( SkillName.Tactics, 60.1, 80.0 );
			SetSkill( SkillName.Wrestling, 55.1, 70.0 );

			Fame = 11000;
			Karma = -11000;

			VirtualArmor = 50;

			CanSwim = true;
			CantWalk = true;

			if( Utility.RandomDouble() < 0.2 )
			{
            Rope rope = new Rope();
			   rope.ItemID = 0x14F8;
			   PackItem( rope );
         }
			
			if( Utility.RandomDouble() < 0.05 )
				PackItem( new MessageInABottle() );
				
			if( Utility.RandomDouble() < 0.02 )
				PackItem( new SailorBones() );
				
			if( Utility.RandomDouble() < 0.02 )
			{
				if( Utility.RandomBool() )
               PackItem( new AnchorEDeed() );
            else
               PackItem( new AnchorSDeed() );
         }

				
			if( Utility.RandomDouble() < 0.5 )
			   PackItem( new SpecialFishingNet() ); //Confirm?
		}

		public override void GenerateLoot()
		{
			AddLoot( LootPack.FilthyRich );
		}

		public override int TreasureMapLevel{ get{ return 4; } }
		public override bool HasBreath{ get{ return true; } }
		public override int BreathPhysicalDamage{ get{ return 20; } } // TODO: Verify damage type
		public override int BreathColdDamage{ get{ return 80; } }
		public override int BreathFireDamage{ get{ return 0; } }
		public override int BreathEffectHue{ get{ return 0x1ED; } }
		public override double BreathDamageScalar{ get{ return 0.05; } }
		public override double BreathMinDelay{ get{ return 5.0; } }
		public override double BreathMaxDelay{ get{ return 7.5; } }

		public override bool IsNotScaredOfDeath{ get{ return true; } } //neutika pri malem poctu hp
		
		public Kraken( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}
