﻿using System;
using Server;
using Server.Items;
using Server.Engines.CannedEvil;

namespace Server.Mobiles
{
	public class AncientSmithy : BaseChampion
	{
		public override ChampionSkullType SkullType{ get{ return ChampionSkullType.Greed; } }
      
      public override int GetAttackSound()
		{
			return 42; // play blacksmith sound
		}

		public override int GetAngerSound()
		{
			return 42; //play blacksmith sound
		}
		
		public override WeaponAbility GetWeaponAbility()
		{
			switch ( Utility.Random( 3 ) )
			{
				default:
				case 0: return WeaponAbility.DoubleStrike;
				case 1: return WeaponAbility.WhirlwindAttack;
				case 2: return WeaponAbility.ArmorIgnore;
			}
		}
      
      [Constructable]
		public AncientSmithy() : this ( true, 12 )
		{
		}
		
      [Constructable]
		public AncientSmithy( int range ) : this ( false, range )
		{
		}
		
      [Constructable]
		public AncientSmithy( bool ischampion, int range ) : base( AIType.AI_Melee, FightMode.Closest, ischampion, range )
		{
			Name = "Ragnar";
         Title = "the Ancient Blacksmith";
			Body = 185;
			BaseSoundID = 42;

			SetStr( 505, 1000 );
			SetDex( 102, 300 );
			SetInt( 402, 600 );

         SetHits(7000, 7200);
         SetStam(105, 300);

         SetDamage(30, 45);

         SetDamageType(ResistanceType.Physical, 50);
         SetDamageType(ResistanceType.Poison, 50);

         SetResistance(ResistanceType.Physical, 85, 90);
         SetResistance(ResistanceType.Fire, 60, 70);
         SetResistance(ResistanceType.Cold, 75, 80);
         SetResistance(ResistanceType.Poison, 75, 80);
         SetResistance(ResistanceType.Energy, 75, 80);

         SetSkill(SkillName.Anatomy, 99.6, 120.0);
         SetSkill(SkillName.Tactics, 99.6, 120.0);
         SetSkill(SkillName.Macing, 99.6, 120.0);
         SetSkill(SkillName.MagicResist, 80.7, 110.0);

			Fame = 22500;
			Karma = -22500;

			VirtualArmor = 80;
			
			PlateGloves gloves = new PlateGloves();
         gloves.Hue = 0x28D;
			gloves.Movable = false;
			AddItem( gloves );

			ChainLegs legs = new ChainLegs();
         legs.Hue = 0x28D;
			legs.Movable = false;
			AddItem( legs );

			WarHammer weapon = new WarHammer();
			weapon.Movable = false;
			AddItem( weapon );

			Boots boots = new Boots();
         boots.Hue = 0x28D;
			boots.Movable = false;
			AddItem( boots );

         HairItemID = 0x2049;
         HairHue = 0x21A;
         FacialHairItemID = 0x203E;
         FacialHairHue = 0x21A;
		}

		public override void GenerateLoot()
		{
			AddLoot( LootPack.UltraRich, 4 );
		}

		public override Poison PoisonImmune{ get{ return Poison.Lethal; } }
		public override bool AlwaysMurderer{ get{ return true; } }
		public override bool AutoDispel{ get{ return true; } }
		public override bool BardImmune{ get{ return true; } }
		public override bool Unprovokable{ get{ return true; } }
		public override bool Uncalmable{ get{ return true; } }

		public AncientSmithy( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
}