using System;
using System.Collections;
using Server;
using Server.Items;
using Server.Spells;
using Server.Engines.CannedEvil;

namespace Server.Mobiles
{
	public class Rikktor : BaseChampion
	{
		public override ChampionSkullType SkullType{ get{ return ChampionSkullType.Power; } }

      [Constructable]
		public Rikktor() : this ( true, 12 )
		{
		}
		
      [Constructable]
		public Rikktor( int range ) : this ( false, range )
		{
		}
		
      [Constructable]
		public Rikktor( bool ischampion, int range ) : base( AIType.AI_Melee, FightMode.Closest, ischampion, range )
		{
			Body = 172;
			Name = "Rikktor";

			SetStr( 801, 900 );
			SetDex( 301, 350 );
			SetInt( 91, 100 );

			SetHits( 3500 );
			SetStam( 503, 650 );

			SetDamage( 28, 55 );

			SetDamageType( ResistanceType.Physical, 25 );
			SetDamageType( ResistanceType.Fire, 50 );
			SetDamageType( ResistanceType.Energy, 25 );

			SetResistance( ResistanceType.Physical, 80, 90 );
			SetResistance( ResistanceType.Fire, 80, 90 );
			SetResistance( ResistanceType.Cold, 30, 40 );
			SetResistance( ResistanceType.Poison, 80, 90 );
			SetResistance( ResistanceType.Energy, 80, 90 );

			SetSkill( SkillName.Anatomy, 120.0 );
			SetSkill( SkillName.MagicResist, 140.2, 160.0 );
			SetSkill( SkillName.Tactics, 120.0 );
			SetSkill( SkillName.Wrestling, 120.1, 130.0 );
			SetSkill( SkillName.Parry, 90.1, 100.0 );

			Fame = 22500;
			Karma = -22500;

			VirtualArmor = 130;
		}

		public override void GenerateLoot()
		{
			AddLoot( LootPack.UltraRich, 4 );
		}

		public override Poison PoisonImmune{ get{ return Poison.Lethal; } }
		public override ScaleType ScaleType{ get{ return ScaleType.All; } }
		public override int Scales{ get{ return 20; } }
		public override HideType HideType{ get{ return HideType.Dragon; } }
		public override int Hides{ get{ return 30; } }
		public override bool BardImmune{ get{ return true; } }
		public override bool Unprovokable{ get{ return true; } }
		public override bool Uncalmable{ get{ return true; } }

		public override void OnGaveMeleeAttack( Mobile defender )
		{
			base.OnGaveMeleeAttack( defender );

			if ( 0.3 >= Utility.RandomDouble() )
				Earthquake();
		}

		public void Earthquake()
		{
			Map map = this.Map;

			if ( map == null )
				return;

			ArrayList targets = new ArrayList();

			foreach ( Mobile m in this.GetMobilesInRange( 14 ) )
			{
				if ( m == this || !CanBeHarmful( m ) )
					continue;

				if ( m is BaseCreature && (((BaseCreature)m).Controlled || ((BaseCreature)m).Summoned || ((BaseCreature)m).Team != this.Team) )
					targets.Add( m );
				else if ( m.Player )
					targets.Add( m );
			}

			PlaySound( 0x2F3 );

			for ( int i = 0; i < targets.Count; ++i )
			{
				Mobile m = (Mobile)targets[i];

				double damage = m.Hits * 0.6;

				if ( damage < 175.0 )
					damage = 175.0;
				else if ( damage > 300.0 )
					damage = 300.0;

				DoHarmful( m );

				AOS.Damage( m, this, (int)damage, 100, 0, 0, 0, 0 );

				if ( m.Alive && m.Body.IsHuman && !m.Mounted )
					m.Animate( 20, 7, 1, true, false, 0 ); // take hit
			}
		}
		
		public override void OnDamage( int amount, Mobile from, bool willKill, int typ )
		{
			base.OnDamage( amount, from, willKill, typ );
			
			// teleports to player
			if ( from is PlayerMobile && !InRange( from.Location, 3 ) && Utility.RandomDouble() < 0.1 )
			{
				Combatant = from;
				
				this.MoveToWorld( from.Location, from.Map );
				this.FixedParticles( 0x376A, 9, 32, 0x13AF, EffectLayer.Waist );
				this.PlaySound( 0x1FE );
			}
		}

		public override int GetAngerSound()
		{
			return Utility.Random( 0x2CE, 2 );
		}

		public override int GetIdleSound()
		{
			return 0x2D2;
		}

		public override int GetAttackSound()
		{
			return Utility.Random( 0x2C7, 5 );
		}

		public override int GetHurtSound()
		{
			return 0x2D1;
		}

		public override int GetDeathSound()
		{
			return 0x2CC;
		}

		public Rikktor( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
}