/*    
-<>>--<<>>--<0>>--<< <<2005>> >>--<<0>--<<>>--<<>-
|        ____________________________            |
|     -=(_)__________________________)=-         |
|          \_    All Crafts 1.0.0    _\          |
|           \_  -------------------   _\         |
|            )       Created By:        )        |
|           /_  Sirsly & Lucid Nagual _/         |
|         _/__________________________/          |
|      -=(_)__________________________)=-        |
|                                                |
-<>>-<< Based off of Daat99's OWLTR system >>-<<>-
*/
using System;
using System.Collections;
using Server;
using Server.Engines.BulkOrders;
using Server.Engines.XmlSpawner2;

namespace Server.Mobiles
{
	public class Bowyer : BaseVendor
	{
		private ArrayList m_SBInfos = new ArrayList();
		protected override ArrayList SBInfos{ get { return m_SBInfos; } }

		[Constructable]
		public Bowyer() : base( "the bowyer" )
		{
			SetSkill( SkillName.Archery, 60.0, 83.0 );
			SetSkill( SkillName.Fletching, 90.0, 100.0 );
		}

		public override void InitSBInfo()
		{
			//m_SBInfos.Add( new SBRingmailArmor() );
			//m_SBInfos.Add( new SBStuddedArmor() );
			//m_SBInfos.Add( new SBLeatherArmor() );
			m_SBInfos.Add( new SBRangedWeapon() );
			m_SBInfos.Add( new SBBowyer() );
		}

		public override VendorShoeType ShoeType
		{
			get{ return Utility.RandomBool() ? VendorShoeType.Boots : VendorShoeType.ThighBoots; }
		}

		public override int GetShoeHue()
		{
			return 0;
		}

		public override void InitOutfit()
		{
			base.InitOutfit();

			AddItem( new Server.Items.Bow() );
			AddItem( new Server.Items.LeatherGorget() );
		}

        #region Bulk Orders
		public override Item CreateBulkOrder( Mobile from, bool fromContextMenu )
		{
			PlayerMobile pm = from as PlayerMobile;
         BODModule bod_mod = (BODModule)XmlAttach.FindAttachment(pm,typeof(BODModule));
         			
			if ( bod_mod == null && from == null )
				return null;

			if ( bod_mod != null )
			{
            if ( bod_mod.NextFletcherBulkOrder == TimeSpan.Zero && ( fromContextMenu || 0.2 > Utility.RandomDouble() ) )
            {
               double theirSkill = pm.Skills[SkillName.Fletching].Base;
    
    				if ( theirSkill >= 70.1 )
    					bod_mod.NextFletcherBulkOrder = TimeSpan.FromHours( 2.0 );
    				else if ( theirSkill >= 50.1 )
    					bod_mod.NextFletcherBulkOrder = TimeSpan.FromHours( 1.0 );
    				else
    					bod_mod.NextFletcherBulkOrder = TimeSpan.FromHours( 0.5 );
    
    				if ( theirSkill >= 70.1 && ((theirSkill - 40.0) / 300.0) > Utility.RandomDouble() )
    				{
    					bod_mod.NextFletcherBulkOrder = TimeSpan.FromHours( 72.0 );
                  return new LargeFletcherBOD();
               }
    
    				return SmallFletcherBOD.CreateRandomFor( from );
    			}
			}
			else
			{
				XmlAttach.AttachTo(from, new BODModule());
				from.SendMessage( 34, "Prosim zkus to znovu" );
			}

			return null;
		}

		public override bool IsValidBulkOrder( Item item )
		{
			return ( item is SmallFletcherBOD || item is LargeFletcherBOD );
		}

		public override bool SupportsBulkOrders( Mobile from )
		{
			return ( from is PlayerMobile && from.Skills[SkillName.Fletching].Base > 0 );
		}

		public override TimeSpan GetNextBulkOrder( Mobile from )
		{
			BODModule bod_mod = (BODModule)XmlAttach.FindAttachment(from,typeof(BODModule));
			
			if ( bod_mod != null && from != null )
				return bod_mod.NextFletcherBulkOrder;
			
			//if ( from is PlayerMobile )
			//	return ((PlayerMobile)from).NextFletcherBulkOrder;

			return TimeSpan.Zero;
		}
		
		public override void OnSuccessfulBulkOrderRecieve( Mobile from )
		{
			PlayerMobile pm = from as PlayerMobile;
			BODModule bod_mod = (BODModule)XmlAttach.FindAttachment(pm,typeof(BODModule));
			
			if ( bod_mod != null && from != null )
         {
            bod_mod.NextFletcherBulkOrder = TimeSpan.Zero;
         }
		}
		#endregion

		public Bowyer( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}
	
