using System;
using System.Collections;
using Server;
using Server.Engines.BulkOrders;
using Server.Engines.XmlSpawner2;

namespace Server.Mobiles
{
	public class Carpenter : BaseVendor
	{
		private ArrayList m_SBInfos = new ArrayList();
		protected override ArrayList SBInfos{ get { return m_SBInfos; } }

		public override NpcGuild NpcGuild{ get{ return NpcGuild.TinkersGuild; } }

		[Constructable]
		public Carpenter() : base( "the carpenter" )
		{
			SetSkill( SkillName.Carpentry, 85.0, 100.0 );
			SetSkill( SkillName.Lumberjacking, 60.0, 83.0 );
		}

		public override void InitSBInfo()
		{
			m_SBInfos.Add( new SBStavesWeapon() );
			m_SBInfos.Add( new SBCarpenter() );
			m_SBInfos.Add( new SBWoodenShields() );
		}

		public override void InitOutfit()
		{
			base.InitOutfit();

			AddItem( new Server.Items.HalfApron() );
		}
		
        #region Bulk Orders
		public override Item CreateBulkOrder( Mobile from, bool fromContextMenu )
		{
			PlayerMobile pm = from as PlayerMobile;
			BODModule bod_mod = (BODModule)XmlAttach.FindAttachment(pm,typeof(BODModule));
			
			if ( bod_mod == null && from == null )
				return null;

			if ( bod_mod != null )
			{
				if ( bod_mod.NextCarpenterBulkOrder == TimeSpan.Zero && ( fromContextMenu || 0.2 > Utility.RandomDouble() ) )
				{
               double theirSkill = pm.Skills[SkillName.Carpentry].Base;

               if ( theirSkill >= 70.1 )
                  bod_mod.NextCarpenterBulkOrder = TimeSpan.FromHours( 2.0 );
               else if ( theirSkill >= 50.1 )
                  bod_mod.NextCarpenterBulkOrder = TimeSpan.FromHours( 1.0 );
               else
                  bod_mod.NextCarpenterBulkOrder = TimeSpan.FromHours( 0.5 );

               if ( theirSkill >= 70.1 && ((theirSkill - 40.0) / 300.0) > Utility.RandomDouble() )
               {
                  bod_mod.NextCarpenterBulkOrder = TimeSpan.FromHours( 72.0 );
                  return new LargeCarpenterBOD();
               }

               return SmallCarpenterBOD.CreateRandomFor( from );
            }
			}
			else
			{
				XmlAttach.AttachTo(from, new BODModule());
				from.SendMessage( 34, "Prosim zkus to znovu" );
			}

			return null;
		}

		public override bool IsValidBulkOrder( Item item )
		{
			return ( item is SmallCarpenterBOD || item is LargeCarpenterBOD );
		}

		public override bool SupportsBulkOrders( Mobile from )
		{
			return ( from is PlayerMobile && from.Skills[SkillName.Carpentry].Base > 0 );
		}

		public override TimeSpan GetNextBulkOrder( Mobile from )
		{
			BODModule bod_mod = (BODModule)XmlAttach.FindAttachment(from,typeof(BODModule));
			
			if ( bod_mod != null && from != null )
				return bod_mod.NextCarpenterBulkOrder;
			
			//if ( from is PlayerMobile )
			//	return ((PlayerMobile)from).NextCarpenterBulkOrder;

			return TimeSpan.Zero;
		}
		
		public override void OnSuccessfulBulkOrderRecieve( Mobile from )
		{
			PlayerMobile pm = from as PlayerMobile;
			BODModule bod_mod = (BODModule)XmlAttach.FindAttachment(pm,typeof(BODModule));
			
			if ( bod_mod != null && from != null )
         {
            bod_mod.NextCarpenterBulkOrder = TimeSpan.Zero;
         }
		}
		#endregion

		public Carpenter( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}
	
