using System; 
using System.Collections; 
using Server.Items; 

namespace Server.Mobiles 
{ 
	public class SBFarmer : SBInfo 
	{ 
		private ArrayList m_BuyInfo = new InternalBuyInfo(); 
		private IShopSellInfo m_SellInfo = new InternalSellInfo(); 

		public SBFarmer() 
		{ 
		} 

		public override IShopSellInfo SellInfo { get { return m_SellInfo; } } 
		public override ArrayList BuyInfo { get { return m_BuyInfo; } } 

		public class InternalBuyInfo : ArrayList 
		{ 
			public InternalBuyInfo() 
			{ 
				Add( new GenericBuyInfo( typeof( Cabbage ), 50, 20, 0xC7B, 0 ) );
				Add( new GenericBuyInfo( typeof( Cantaloupe ), 50, 20, 0xC79, 0 ) );
				Add( new GenericBuyInfo( typeof( Carrot ), 50, 20, 0xC78, 0 ) );
				Add( new GenericBuyInfo( typeof( HoneydewMelon ), 100, 20, 0xC74, 0 ) );
				Add( new GenericBuyInfo( typeof( Squash ), 50, 20, 0xC72, 0 ) );
				Add( new GenericBuyInfo( typeof( Lettuce ), 50, 20, 0xC70, 0 ) );
				Add( new GenericBuyInfo( typeof( Onion ), 1, 50, 0xC6D, 0 ) );
				Add( new GenericBuyInfo( typeof( Pumpkin ), 200, 20, 0xC6A, 0 ) );
				Add( new GenericBuyInfo( typeof( GreenGourd ), 50, 20, 0xC66, 0 ) );
				Add( new GenericBuyInfo( typeof( YellowGourd ), 50, 20, 0xC64, 0 ) );
				//Add( new GenericBuyInfo( typeof( Turnip ), 6, 20, XXXXXX, 0 ) );
				Add( new GenericBuyInfo( typeof( Watermelon ), 200, 20, 0xC5C, 0 ) );
				//Add( new GenericBuyInfo( typeof( EarOfCorn ), 3, 20, XXXXXX, 0 ) );
				Add( new GenericBuyInfo( typeof( Eggs ), 5, 20, 0x9B5, 0 ) );
				Add( new BeverageBuyInfo( typeof( Pitcher ), BeverageType.Milk, 7, 20, 0x9AD, 0 ) );
				Add( new GenericBuyInfo( typeof( Peach ), 50, 20, 0x9D2, 0 ) );
				Add( new GenericBuyInfo( typeof( Pear ), 50, 20, 0x994, 0 ) );
				Add( new GenericBuyInfo( typeof( Lemon ), 50, 20, 0x1728, 0 ) );
				Add( new GenericBuyInfo( typeof( Lime ), 50, 20, 0x172A, 0 ) );
				Add( new GenericBuyInfo( typeof( Grapes ), 50, 20, 0x9D1, 0 ) );
				Add( new GenericBuyInfo( typeof( Apple ), 50, 20, 0x9D0, 0 ) );
				Add( new GenericBuyInfo( typeof( SheafOfHay ), 10, 20, 0xF36, 0 ) );

			} 
		} 

		public class InternalSellInfo : GenericSellInfo 
		{ 
			public InternalSellInfo() 
			{ 
				Add( typeof( Pitcher ), 5 );
				Add( typeof( Eggs ), 1 );
				Add( typeof( Apple ), 1 );
				Add( typeof( Grapes ), 1 );
				Add( typeof( Watermelon ), 3 );
				Add( typeof( YellowGourd ), 1 );
				Add( typeof( GreenGourd ), 1 );
				Add( typeof( Pumpkin ), 5 );
				Add( typeof( Onion ), 1 );
				Add( typeof( Lettuce ), 2 );
				Add( typeof( Squash ), 1 );
				Add( typeof( Carrot ), 1 );
				Add( typeof( HoneydewMelon ), 3 );
				Add( typeof( Cantaloupe ), 3 );
				Add( typeof( Cabbage ), 2 );
				Add( typeof( Lemon ), 1 );
				Add( typeof( Lime ), 1 );
				Add( typeof( Peach ), 1 );
				Add( typeof( Pear ), 1 );
				Add( typeof( SheafOfHay ), 1 );
			} 
		} 
	} 
}