﻿using System;
using System.Xml;
using Server;
using Server.Mobiles;
using Server.Regions;

namespace Server.Regions
{
	public class DuelRegion : BaseRegion
	{
		public DuelRegion( XmlElement xml, Map map, Region parent ) : base( xml, map, parent )
		{			
		}
		
		public override bool AllowHousing( Mobile from, Point3D p )
		{
			return false;
		}
		
		public override void OnEnter( Mobile m )
		{
			if ( m is PlayerMobile )
				m.SendMessage( 34, "POZOR, vstupujes do PvP regionu!" );
		}
		
// 		public override bool OnBeginSpellCast( Mobile m, ISpell s )
// 		{
// 			if ( ( s is GateTravelSpell || s is MarkSpell ) && m.AccessLevel == AccessLevel.Player )
// 			{
// 				m.SendLocalizedMessage( 501802 ); // Thy spell doth not appear to work...
// 				
// 				return false;
// 			}
// 			
// 			return base.OnBeginSpellCast( m, s );
// 		}
	}
}