using System;
using Server.Items;

namespace Server.SkillHandlers
{
	public class Stealth
	{
		public static void Initialize()
		{
			SkillInfo.Table[(int)SkillName.Stealth].Callback = new SkillUseCallback(OnUse);
		}

		public static int[, ] ArmorTable { get { return m_ArmorTable; } }
		private static int[, ] m_ArmorTable = new int[, ]
		{
			//	Gorget	Gloves	Helmet	Arms	Legs	Chest	Shield
			/* Cloth	*/	{ 1,	1,		2,		4,		4,		6,		0 },
			/* Leather	*/	{ 2,	2,		3,		6,		8,		10,		0 },
			/* Studded	*/	{ 3,	3,		4,		10,		12,		14,		0 },
			/* Bone		*/ 	{ 10,	10,		16,		20,		22,		25,		0 },
			/* Spined	*/	{ 0,	0,		0,		0,		0,		0,		0 },
			/* Horned	*/	{ 0,	0,		0,		0,		0,		0,		0 },
			/* Barbed	*/	{ 0,	0,		0,		0,		0,		0,		0 },
			/* DragonL	*/	{ 0,		0,		0,		0,		0,		0,		0 },
			/* Daemon	*/	{ 0,		0,		0,		0,		0,		0,		0 },
			/* Ring		*/	{ 10,	10,		16,		22,		24,		30,		0 },
			/* Chain	*/	{ 10,	10,		16,		22,		24,		30,		0 },
			/* Plate	*/	{ 15,	15,		20,		25,		30,		35,		20 },
			/* Dragon	*/	{ 12,	15,		18,		25,		28,		33,		0 }
		};

		public static int GetArmorRating(Mobile m)
		{
			if(m.Map == Map.Underworld)
				return (int)m.ArmorRating;

			int ar = 0;

			for(int i = 0; i < m.Items.Count; i++)
			{
				BaseArmor armor = m.Items[i] as BaseArmor;

				if(armor != null)
				{
					ar += (armor.ArmorAttributes.MageArmor == 0) ? m_ArmorTable[(int)armor.MaterialType, (int)armor.BodyPosition] : m_ArmorTable[(int)armor.MaterialType, (int)armor.BodyPosition]/2;
					// 					if ( (int) from.AccessLevel > (int) AccessLevel.Counselor )
					//                   m.SendMessage("Type: {0}, Pos: {1}, Ar:{2}", armor.MaterialType.ToString(), armor.BodyPosition.ToString(),(armor.ArmorAttributes.MageArmor == 0) ? m_ArmorTable[(int)armor.MaterialType, (int)armor.BodyPosition] : m_ArmorTable[(int)armor.MaterialType, (int)armor.BodyPosition]/2);
				}
			}

			if (ar < 25) ar = 25;

			//          if ( (int) from.AccessLevel > (int) AccessLevel.Player )
			//             m.SendMessage("Celkem AR: {0}", ar.ToString());

			return ar;
		}

		public static TimeSpan OnUse(Mobile m)
		{
			if (!m.Hidden)
			{
				m.SendLocalizedMessage(502725); // You must hide first
			}
			else if (m.Skills[SkillName.Hiding].Base < 80.0)
			{
				m.SendLocalizedMessage(502726); // You are not hidden well enough.  Become better at hiding.
				m.RevealingAction();
			}
			else if (m.Hidden && m.AllowedStealthSteps > 0)
				m.SendMessage("Jiz jsi ve stealth modu");
			else
			{
				int armorRating = GetArmorRating(m);
				//             if ( (int) from.AccessLevel > (int) AccessLevel.Player )
				//                m.SendMessage("Sance: {0} - {1}", -20.0 + (armorRating * 2), (Core.AOS ? 60.0 : 80.0) + (armorRating * 2));

				if (armorRating >= 42)	//I have a hunch '42' was chosen cause someone's a fan of DNA
				{
					m.SendLocalizedMessage(502727); // You could not hope to move quietly wearing this much armor.
					m.RevealingAction();
				}
				else if (m.CheckSkill(SkillName.Stealth, -20.0 + (armorRating * 2), 85.0 + (armorRating * 2)))
				{
					int steps = (m.Map == Map.Underworld) ? Utility.RandomMinMax( 1, 10 ) : (int)(m.Skills[SkillName.Stealth].Value / 5.0);

					if (steps < 1)
						steps = 1;

					m.AllowedStealthSteps = steps;

					m.SendLocalizedMessage(502730); // You begin to move quietly.

					return TimeSpan.FromSeconds(10.0);
				}
				else
				{
					m.SendLocalizedMessage(502731); // You fail in your attempt to move unnoticed.
					m.RevealingAction();
				}
			}

			return TimeSpan.FromSeconds(10.0);
		}
	}
}