using System;
using System.Collections;
using Server;
using Server.Mobiles;
using Server.Network;
using Server.Items;
using Server.Targeting;

namespace Server.Spells.Chivalry
{
	public class EnemyOfOneSpell : PaladinSpell
	{
		private static SpellInfo m_Info = new SpellInfo(
				"Enemy of One", "Forul Solum",
				SpellCircle.Second, // 0 + 0.5 = 0.5s base cast delay
				-1,
				9002
			);

		public override double RequiredSkill{ get{ return 45.0; } }
		public override int RequiredMana{ get{ return 20; } }
		public override int RequiredTithing{ get{ return 10; } }
		public override int MantraNumber{ get{ return 1060723; } } // Forul Solum
		public override bool BlocksMovement{ get{ return false; } }

		public EnemyOfOneSpell( Mobile caster, Item scroll ) : base( caster, scroll, m_Info )
		{
		}

		public override void OnCast()
		{
			if ( CheckSequence() )
			{
				Caster.PlaySound( 0x0F5 );
				Caster.PlaySound( 0x1ED );
				Caster.FixedParticles( 0x375A, 1, 30, 9966, 33, 2, EffectLayer.Head );
				Caster.FixedParticles( 0x37B9, 1, 30, 9502, 43, 3, EffectLayer.Head );

				Timer t = (Timer)m_Table[Caster];

				if ( t != null )
					t.Stop();

				double delay = (double)ComputePowerValue( 1 ) / 60;

				// TODO: Should caps be applied?
				if ( delay < 1.5 )
					delay = 1.5;
				else if ( delay > 3.5 )
					delay = 3.5;

				m_Table[Caster] = Timer.DelayCall( TimeSpan.FromMinutes( delay ), new TimerStateCallback( Expire_Callback ), Caster );

				if ( Caster is PlayerMobile )
				{
					((PlayerMobile)Caster).EnemyOfOneType = null;
					((PlayerMobile)Caster).WaitingForEnemy = true;
					
// 					BuffInfo.AddBuff( Caster, new BuffInfo( BuffIcon.EnemyOfOne, 1075653, "50\tprimary\tenemy\t100", true ) );
//+~1_PERCENT~% damage to the creature you next attack.<br>+~2_PERCENT~% damage from anything except the creature you next attack.	1075902
					
               BuffInfo.AddBuff( Caster, new BuffInfo( BuffIcon.EnemyOfOne, 1075653, 1075654, TimeSpan.FromMinutes( delay ), Caster, new TextDefinition( ( Caster.ChestArmor is PlateOfJustice && ((PlateOfJustice)Caster.ChestArmor).Bonus > 4 ) ? "65\tprimary\tenemy\t100" : "50\tprimary\tenemy\t100" ), true ) );
				}
			}

			FinishSequence();
		}

		private static Hashtable m_Table = new Hashtable();

		private static void Expire_Callback( object state )
		{
			Mobile m = (Mobile)state;

			m_Table.Remove( m );

			m.PlaySound( 0x1F8 );

			if ( m is PlayerMobile )
			{
				((PlayerMobile)m).EnemyOfOneType = null;
				((PlayerMobile)m).WaitingForEnemy = false;
				BuffInfo.RemoveBuff( m, BuffIcon.EnemyOfOne );
			}
		}
	}
}