using System;
using System.Collections;
using Server.Network;
using Server.Items;
using Server.Targeting;
using Server.Gumps;
using Server.Mobiles;

namespace Server.Spells.Necromancy
{
	public class SummonFamiliarCreatureSpell : NecromancerSpell
	{
		private static SpellInfo m_Info = new SpellInfo(
				"Summon Familiar", "Kal Xen Bal",
				SpellCircle.Sixth, // 0.5 + 1.5 = 2s base cast delay
				203,
				9031,
				Reagent.BatWing,
				Reagent.GraveDust,
				Reagent.DaemonBlood
			);

		public override double RequiredSkill{ get{ return 30.0; } }
		public override int RequiredMana{ get{ return 17; } }

		public SummonFamiliarCreatureSpell( Mobile caster, Item scroll ) : base( caster, scroll, m_Info )
		{
		}

		private static Hashtable m_Table = new Hashtable();

		public static Hashtable Table{ get{ return m_Table; } }

		public override bool CheckCast()
		{
			BaseCreature check = (BaseCreature)m_Table[Caster];

			if ( check != null && !check.Deleted )
			{
				Caster.SendLocalizedMessage( 1061605 ); // You already have a familiar.
				return false;
			}

			return base.CheckCast();
		}

		public override void OnCast()
		{

		int index = Utility.Random(5);

			if ( index >= 0 && index < m_Entries.Length )
			{
				SummonFamiliarEntry entry = m_Entries[index];

				double necro = Caster.Skills[SkillName.Necromancy].Base;
				double spirit = Caster.Skills[SkillName.SpiritSpeak].Base;

				BaseCreature check = (BaseCreature)SummonFamiliarCreatureSpell.Table[Caster];
				
				
					try
					{
						BaseCreature bc = (BaseCreature)Activator.CreateInstance( entry.Type );

						bc.Skills.MagicResist = Caster.Skills.MagicResist;

						if ( BaseCreature.Summon( bc, Caster, Caster.Location, -1, TimeSpan.FromDays( 1.0 ) ) )
						{
							Caster.FixedParticles( 0x3728, 1, 10, 9910, EffectLayer.Head );
							bc.PlaySound( bc.GetIdleSound() );
							SummonFamiliarCreatureSpell.Table[Caster] = bc;
						}
					}
					catch
					{
					}
				
			}	
		
		
		
		
		
			FinishSequence();
		}

		private static SummonFamiliarEntry[] m_Entries = new SummonFamiliarEntry[]
			{
				new SummonFamiliarEntry( typeof( HordeMinionFamiliar ), 1060146,  30.0,  30.0 ), // Horde Minion
				new SummonFamiliarEntry( typeof( ShadowWispFamiliar ), 1060142,  50.0,  50.0 ), // Shadow Wisp
				new SummonFamiliarEntry( typeof( DarkWolfFamiliar ), 1060143,  60.0,  60.0 ), // Dark Wolf
				new SummonFamiliarEntry( typeof( DeathAdder ), 1060145,  80.0,  80.0 ), // Death Adder
				new SummonFamiliarEntry( typeof( VampireBatFamiliar ), 1060144, 100.0, 100.0 )  // Vampire Bat
			};

		public static SummonFamiliarEntry[] Entries{ get{ return m_Entries; } }
	}

	

}