using System;
using System.Collections;
using Server.Network;
using Server.Items;
using Server.Targeting;
using Server.Mobiles;

namespace Server.Spells.Necromancy
{
	public class WitherCreatureSpell : NecromancerSpell
	{
		private static SpellInfo m_Info = new SpellInfo(
				"Wither", "Kal Vas An Flam",
				SpellCircle.Third, // 0.5 + 0.75 = 1.25s base cast delay
				203,
				9031,
				Reagent.NoxCrystal,
				Reagent.GraveDust,
				Reagent.PigIron
			);
			
		

		public override double RequiredSkill{ get{ return 50.0; } }
		public override int RequiredMana{ get{ return 23; } }

		public WitherCreatureSpell( Mobile caster, Item scroll) : base( caster, scroll, m_Info )
		{
		
		}

		public override bool DelayedDamage{ get{ return false; } }

		public override void OnCast()
		{
			if ( CheckSequence() )
			{
				/* Creates a withering frost around the Caster,
				 * which deals Cold Damage to all valid targets in a radius of 5 tiles.
				 */

				Map map = Caster.Map;

				if ( map != null )
				{
					ArrayList targets = new ArrayList();

				
					
			if ((Caster is BaseCreature) && (((BaseCreature)Caster).Controlled || ((BaseCreature)Caster).Summoned ))  //different area of effect if summoned (from animate dead)
			{
					foreach ( Mobile targ in Caster.GetMobilesInRange( 5 ) )
					{
							if ( (Caster == targ || SpellHelper.ValidIndirectTarget( Caster, targ )) && Caster.CanBeHarmful( targ, false ) )
							targets.Add( targ );	
					}
			}
			else
			{

					foreach ( Mobile targ in Caster.GetMobilesInRange( 5 ) )
					{
							if ( targ == Caster )
							continue;

							if ( targ is BaseCreature && (((BaseCreature)targ).Controlled || ((BaseCreature)targ).Summoned ))
							targets.Add( targ );
							else if ( targ.Player )
							targets.Add( targ );
					}
					
			}
					

					
					

					Effects.PlaySound( Caster.Location, map, 0x1FB );
					Effects.PlaySound( Caster.Location, map, 0x10B );
					Effects.SendLocationParticles( EffectItem.Create( Caster.Location, map, EffectItem.DefaultDuration ), 0x37CC, 1, 40, 97, 3, 9917, 0 );

					for ( int i = 0; i < targets.Count; ++i )
					{
						Mobile m = (Mobile)targets[i];

						Caster.DoHarmful( m );
						m.FixedParticles( 0x374A, 1, 15, 9502, 97, 3, (EffectLayer)255 );

						double damage = Utility.RandomMinMax( 30, 35 );

						damage *= (300 + (m.Karma / 100) + (GetDamageSkill( Caster ) * 10));
						damage /= 1000;

						// TODO: cap?
						//if ( damage > 40 )
						//	damage = 40;

						SpellHelper.Damage( this, m, damage, 0, 0, 100, 0, 0 );
					}
				}
			}

			FinishSequence();
		}
	}
}