using System;
using Server.Mobiles;
using Server.Network;
using Server.Targeting;

namespace Server.Spells.Eighth
{
	public class SummonDaemonSpell : Spell
	{
		private static SpellInfo m_Info = new SpellInfo(
				"Summon Daemon", "Kal Vas Xen Corp",
				SpellCircle.Eighth,
				269,
				9050,
				false,
				Reagent.Bloodmoss,
				Reagent.MandrakeRoot,
				Reagent.SpidersSilk,
				Reagent.SulfurousAsh
			);

		public SummonDaemonSpell( Mobile caster, Item scroll ) : base( caster, scroll, m_Info )
		{
		}

		public override bool CheckCast()
		{
			if ( !base.CheckCast() )
				return false;

			if ( (Caster.Followers + (Core.SE ? 4 : 5)) > Caster.FollowersMax )
			{
				Caster.SendLocalizedMessage( 1049645 ); // You have too many followers to summon that creature.
				return false;
			}

			return true;
		}

		public override void OnCast()
		{
			if ( CheckSequence() )
			{
				TimeSpan duration = TimeSpan.FromSeconds( (2 * Caster.Skills.Magery.Fixed) / 5 );
            BaseCreature summon = new SummonedDaemon();
            
            //TALENT
            if ( Caster is PlayerMobile && Caster.Map != Map.Underworld )
            {
               PlayerMobile.TalentEntry te = ((PlayerMobile)Caster).GetTalent( PlayerMobile.TalentType.Invokace );
               
               if ( te != null && te.Enabled && te.Charges >= 100 )
               {
          			summon.Name = NameList.RandomName( "balron" );
          			summon.Body = 40;
          
          			summon.SetStr( 986, 1185 );
          			summon.SetDex( 177, 255 );
          			summon.SetInt( 151, 250 );
          
          			summon.SetHits( 592, 711 );
          
          			summon.SetDamage( 22, 29 );
          
          			summon.SetDamageType( ResistanceType.Physical, 50 );
          			summon.SetDamageType( ResistanceType.Fire, 25 );
          			summon.SetDamageType( ResistanceType.Energy, 25 );          

          			summon.SetResistance( ResistanceType.Poison, 100 );
          
          			summon.VirtualArmor = 90;
                  
                  te.Charges -= 100;
                     
                  if ( te.Charges < 100 )
                     te.Enabled = false;
               }
            }
            
            SpellHelper.Summon( summon, Caster, 0x216, duration, false, false );
			}

			FinishSequence();
		}
	}
}