using System;
using Server.Mobiles;
using Server.Network;
using Server.Targeting;
using Server.Menus.ItemLists;

namespace Server.Spells.Fifth
{
	public class SummonCreatureSpell : Spell
	{
		private static SpellInfo m_Info = new SpellInfo(
				"Summon Creature", "Kal Xen",
				SpellCircle.Fifth,
				266,
				9040,
				Reagent.Bloodmoss,
				Reagent.MandrakeRoot,
				Reagent.SpidersSilk
			);

		public SummonCreatureSpell( Mobile caster, Item scroll ) : base( caster, scroll, m_Info )
		{
		}
		
		public override bool CheckCast()
		{
			if ( !base.CheckCast() )
				return false;

			if ( (Caster.Followers + 2) > Caster.FollowersMax )
			{
				Caster.SendLocalizedMessage( 1049645 ); // You have too many followers to summon that creature.
				return false;
			}

			return true;
		}

		// TODO: Get real list
		private static Type[] m_Types = new Type[]
			{
				typeof( Horse ),
				typeof( GrizzlyBear ),
				typeof( BlackBear ),
				typeof( BrownBear ),
				typeof( PolarBear ),
				typeof( Walrus ),
				typeof( GreatHart ),
				typeof( Hind ),
				typeof( Dog ),
				typeof( Boar ),
				typeof( Chicken ),
				typeof( Rabbit )
			};

		private static ItemListEntry[] Entrys()
		{
			ItemListEntry[] entries = new ItemListEntry[12];

			entries[0] = new ItemListEntry( "Horse", 8479 );
			entries[1] = new ItemListEntry( "Grizzly Bear", 8411 );
			entries[2] = new ItemListEntry( "Black Bear", 8472 );
			entries[3] = new ItemListEntry( "Brown Bear", 8399 );
         entries[4] = new ItemListEntry( "Polar Bear", 8417 );
			entries[5] = new ItemListEntry( "Walrus", 8447 );
			entries[6] = new ItemListEntry( "Great Hart", 8404 );
			entries[7] = new ItemListEntry( "Hind", 8404 );
			entries[8] = new ItemListEntry( "Dog", 8476 );
			entries[9] = new ItemListEntry( "Boar", 8449 );
			entries[10] = new ItemListEntry( "Chicken", 8401 );
			entries[11] = new ItemListEntry( "Rabbit", 8485 );
			
			return entries;
		}
		
		private class SummonCreatureMenu : ItemListMenu
		{
			private Mobile m_Mobile;

			public SummonCreatureMenu() : base( "Jake zvire chces vykouzlit?", Entrys() )
			{
			}

			public override void OnResponse( NetState state, int index )
			{
				if ( index >= 0 && index < 12 )
				{
               try
    				{
    					BaseCreature creature = (BaseCreature)Activator.CreateInstance( m_Types[index] );
    
    					creature.ControlSlots = 2;
    
    					TimeSpan duration;
    
    					if ( state.Mobile.Map != Map.Underworld )
    						duration = TimeSpan.FromSeconds( (2 * state.Mobile.Skills.Magery.Fixed) / 5 );
    					else
    						duration = TimeSpan.FromSeconds( 4.0 * state.Mobile.Skills[SkillName.Magery].Value );
    
    					SpellHelper.Summon( creature, state.Mobile, 0x215, duration, false, false );
    				}
    				catch
    				{
    				}
				}
			}
		}

		public override void OnCast()
		{
			if ( CheckSequence() )
			{
				if ( Caster != null )
					Caster.SendMenu( new SummonCreatureMenu() );
			}

			FinishSequence();
		}

		public override TimeSpan GetCastDelay()
		{
			if ( Caster.Map != Map.Underworld )
				return TimeSpan.FromTicks( base.GetCastDelay().Ticks * 2 ); //default Ticks * 2

			return base.GetCastDelay() + TimeSpan.FromSeconds( 6.0 );
		}
	}
}