using System;
using System.Collections;
using Server.Network;
using Server.Items;
using Server.Engines.CannedEvil;
using Server.Guilds;
using Server.Factions;
using Server.Engines.PartySystem;
using Server.Regions;

namespace Server.Spells.Necromancy
{
	public class ExorcismSpell : NecromancerSpell
	{
		private static SpellInfo m_Info = new SpellInfo(
				"Exorcism", "Ort Corp Grav",
				SpellCircle.Seventh,
				203,
				9031,
				Reagent.NoxCrystal,
				Reagent.GraveDust
			);

		public override double RequiredSkill { get { return 80.0; } }
		public override int RequiredMana { get { return 40; } }

		public ExorcismSpell( Mobile caster, Item scroll ) : base( caster, scroll, m_Info )
		{
		}

		public override bool CheckCast()
		{
			if( Caster.Skills.SpiritSpeak.Value < 100.0 )
			{
				Caster.SendLocalizedMessage( 1072112 ); // You must have GM Spirit Speak to use this spell
				return false;
			}

			return base.CheckCast();
		}


		public override bool DelayedDamage { get { return false; } }

		private const int Range = 18;

		public override int ComputeKarmaAward()
		{
			return 0;	//no karma lost from this spell!
		}

		public override void OnCast()
		{
         if( CheckSequence() )
			{
				if ( Caster.Map != null )
				{
					ArrayList targets = new ArrayList();
					SlayerEntry atkSlayer = SlayerGroup.GetEntryByName(SlayerName.Exorcism);

					foreach ( Mobile m in Caster.GetMobilesInRange( 5 ) )
					{
						if ( Caster != m && Caster.InLOS( m ) && SpellHelper.ValidIndirectTarget( Caster, m ) && Caster.CanBeHarmful( m, false ) )
						{
                     if (atkSlayer != null && atkSlayer.Slays(m))	
                        targets.Add( m );
                  }
					}

					for ( int i = 0; i < targets.Count; ++i )
					{
						Mobile m = (Mobile)targets[i];

						Caster.DoHarmful( m );
                  m.FixedParticles( 0x3709, 1, 30, 9965, 5, 7, EffectLayer.Waist );
                  m.FixedParticles( 0x376A, 1, 30, 9502, 5, 3, EffectLayer.Waist );
                  m.PlaySound( 0x231 );

						double damage = Utility.RandomMinMax( 90, 115 );

						damage *= (300 + (m.Karma / 100) + (GetDamageSkill( Caster ) * 10));
						damage /= 1000;

						SpellHelper.Damage( this, m, damage, 0, 0, 50, 0, 50 );
						m.Freeze(TimeSpan.FromSeconds(3.0));
					}
				}
			}

			FinishSequence();
		}
	}
}