using System;
using Server.Targeting;
using Server.Mobiles;

namespace Server.Spells.Spellweaving
{
	public class DryadAllureSpell : ArcanistSpell
	{
		private static SpellInfo m_Info = new SpellInfo(
                "Dryad Allure", "Rathril",
                SpellCircle.Tenth, // 0.5 + 2.5 = 3s base cast delay
				-1
			);

        public override double RequiredSkill { get { return 52.0; } }
        public override int RequiredMana { get { return 40; } }

        public DryadAllureSpell( Mobile caster, Item scroll ) : base( caster, scroll, m_Info )
		{
		}

		public override void OnCast()
		{
// 			Caster.Target = new InternalTarget( this );
				Caster.SendMessage( "Toto kouzlo je docasne nefunkcni." );
		}

		public void Target( Mobile m )
		{
			if( !Caster.CanSee( m.Location ) || !Caster.InLOS( m ) )
			{
				Caster.SendLocalizedMessage( 500237 ); // Target can not be seen.
			}
			else if( m.Player || !( m is BaseCreature ) || m is BaseChampion || !m.Body.IsHuman )
			{
				Caster.SendLocalizedMessage( 1074379 ); // You cannot charm that!
			}
			else
			{
				BaseCreature bc = (BaseCreature)m;

				if( bc.IsParagon || bc.IsTeragon ) //TODO: Correct formula for paragons?
				{
					Caster.SendLocalizedMessage( 1074379 ); // You cannot charm that!
				}
				if( bc.Allured || bc.Controlled || bc.Summoned )
				{
					Caster.SendLocalizedMessage( 1074380 ); // This humanoid is already controlled by someone else.
				}
				else if( CheckSequence() )
				{
					int level = GetFocusLevel();
					double skill = Caster.Skills[SkillName.Spellweaving].Value;

					double chance = ( skill / 240 ) + ( level / 50 ); // Floor( Skill / 240 ) + ( FocusLevel / 50 )

					if( chance > Utility.RandomDouble() )
					{
						if( Allure( Caster, bc ) )
						{
							Caster.SendLocalizedMessage( 1074377 ); // You allure the humanoid to follow and protect you.
						}
					}
					else
					{
						bc.PlaySound( 0x5C5 );
						bc.ControlTarget = Caster;
						bc.ControlOrder = OrderType.Attack;
						bc.Combatant = Caster;

						Caster.SendLocalizedMessage( 1074378 ); // The humanoid becomes enraged by your charming attempt and attacks you.
					}
				}
			}

			FinishSequence();
		}

		public static bool Allure( Mobile allurer, BaseCreature bc )
		{
			if( bc.Allured || bc.Controlled || bc.Summoned ) // Sanity.
			{
				allurer.SendLocalizedMessage( 1074380 ); // This humanoid is already controlled by someone else.
				return false;
			}

			int c = bc.ControlSlots;

			bc.ControlSlots = 3;

			if( bc.SetControlMaster( allurer ) )
			{
				bc.PlaySound( 0x5C4 );
				bc.Allured = true;
			}
			else
			{
				bc.ControlSlots = c;
				return false;
			}

			return true;
		}

		public class InternalTarget : Target
		{
			private DryadAllureSpell m_Owner;

			public InternalTarget( DryadAllureSpell owner ) : base( 12, false, TargetFlags.None )
			{
				m_Owner = owner;
			}

			protected override void OnTarget( Mobile m, object o )
			{
				if( o is Mobile )
				{
					m_Owner.Target( (Mobile)o );
				}
				else
				{
					m.SendLocalizedMessage( 1074379 ); // You cannot charm that!
				}
			}

			protected override void OnTargetFinish( Mobile m )
			{
				m_Owner.FinishSequence();
			}
		}
	}
}