using System;
using System.Collections;
using System.Collections.Generic;

namespace Server.Spells.Spellweaving
{
	public class EssenceOfWindSpell : ArcanistSpell
	{
		private static SpellInfo m_Info = new SpellInfo(
                "Essence of Wind", "Anathrae",
                SpellCircle.Tenth, // 0.5 + 2.5 = 3s base cast delay
				-1
			);

        public override double RequiredSkill { get { return 52.0; } }
        public override int RequiredMana { get { return 40; } }

        public EssenceOfWindSpell( Mobile caster, Item scroll ) : base( caster, scroll, m_Info )
		{
		}

		public override void OnCast()
		{
			if( CheckSequence() )
			{
				Caster.PlaySound( 0x5C6 );

				int level = GetFocusLevel();
				double skill = Caster.Skills[SkillName.Spellweaving].Value;

				int tiles = 5 + level; // 5 + FocusLevel
				int damage = 40 + level; // 25 + FocusLevel
				int duration = Utility.RandomMinMax( 1, (int)Math.Floor( skill / 24 ) ) + level; // RandomMinMax( 1, Floor( Skill / 24 ) ) + FocusLevel
				int fcMalus = 1;
				int ssiMalus = 10;

				List<Mobile> targets = new List<Mobile>();

				foreach( Mobile m in Caster.GetMobilesInRange( tiles ) )
					if( Caster != m && Caster.InLOS( m ) && SpellHelper.ValidIndirectTarget( Caster, m ) && Caster.CanBeHarmful( m, false ) )
						targets.Add( m );

				for( int i = 0; i < targets.Count; i++ )
				{
					Mobile m = targets[i];

					Caster.DoHarmful( m );

					SpellHelper.Damage( this, m, damage, 0, 0, 100, 0, 0 );

					if( CheckResisted( m ) )
					{
						m.SendLocalizedMessage( 501783 ); // You feel yourself resisting magical energy.
					}
					else
					{
						m_Table[m] = new EssenceOfWindInfo( m, fcMalus, ssiMalus, TimeSpan.FromSeconds( duration ) );

						BuffInfo.AddBuff( m, new BuffInfo( BuffIcon.EssenceOfWind, 1075802, 1075803, TimeSpan.FromSeconds( duration ), m, new TextDefinition( String.Format( "{0}\t{1}", ToTicksString( fcMalus ), ToTicksString( ssiMalus ) ) ) ) );
					}
				}
			}

			FinishSequence();
		}

		private static Hashtable m_Table = new Hashtable();

		private class EssenceOfWindInfo
		{
			public Mobile m_Defender;
			public int m_FCMalus;
			public int m_SSIMalus;
			public ExpireTimer m_Timer;

			public EssenceOfWindInfo( Mobile defender, int fcMalus, int ssiMalus, TimeSpan duration )
			{
				m_Defender = defender;
				m_FCMalus = fcMalus;
				m_SSIMalus = ssiMalus;

				m_Timer = new ExpireTimer( m_Defender, duration );
				m_Timer.Start();
			}
		}

		public static int GetCastMalus( Mobile m )
		{
			EssenceOfWindInfo info = m_Table[m] as EssenceOfWindInfo;

			if( info == null )
				return 0;

			return info.m_FCMalus;
		}

		public static int GetSwingMalus( Mobile m )
		{
			EssenceOfWindInfo info = m_Table[m] as EssenceOfWindInfo;

			if( info == null )
				return 0;

			return info.m_SSIMalus;
		}

		public static bool StopDebuffing( Mobile m, bool message )
		{
			EssenceOfWindInfo info = m_Table[m] as EssenceOfWindInfo;

			if( info == null || info.m_Timer == null )
				return false;

			info.m_Timer.DoExpire( message );
			return true;
		}

		private class ExpireTimer : Timer
		{
			private Mobile m_Mobile;

			public ExpireTimer( Mobile m, TimeSpan delay ) : base( delay )
			{
				m_Mobile = m;
			}

			protected override void OnTick()
			{
				DoExpire( true );
			}

			public void DoExpire( bool message )
			{
				Stop();
				/*
				if( message )
				{
				}
				*/
				m_Table.Remove( m_Mobile );

				BuffInfo.RemoveBuff( m_Mobile, BuffIcon.EssenceOfWind );
			}
		}
	}
}