using System;

namespace Server.Spells.Spellweaving
{
	public class EtherealVoyageSpell : ArcaneForm
	{
		private static SpellInfo m_Info = new SpellInfo(
                "Ethereal Voyage", "Orlavdra",
                SpellCircle.Twelveth, // 0.5 + 3.0 = 3.5s base cast delay
				-1
			);

      public override double RequiredSkill { get { return 24.0; } }
      public override int RequiredMana { get { return 32; } }

		public override int Body { get { return 0x302; } }
		public override int Hue { get { return 0x48F; } }

      public EtherealVoyageSpell( Mobile caster, Item scroll ) : base( caster, scroll, m_Info )
		{
		}

		public override bool CheckCast()
		{
			if( UnderTransformation( Caster, GetType() ) )
			{
				Caster.SendLocalizedMessage( 501775 ); // This spell is already in effect.
				return false;
			}
			else if( Locked )
			{
				Caster.SendLocalizedMessage( 1075124 ); // You must wait before casting that spell again.
				return false;
			}
         else if ( Caster.Map == Map.Auberon || Caster.Map == Map.Underworld )
			{
				Caster.SendLocalizedMessage( 501802 ); // Thy spell doth not appear to work...
				return false;
			}
			
			return base.CheckCast();
		}

		public override void PlayEffect( Mobile m )
		{
			m.PlaySound( 0x5C8 );			
			m.SendLocalizedMessage( 1074770 ); // You are now under the effects of Ethereal Voyage.

			/* Tested in Osi.
			 * 
			 * Test values:
			 * 
			 * Without Arcane Focus:
			 *  24.0 = 13 secs.
			 *  30.0 = 13 secs.
			 *  94.0 = 15 secs.
			 * 120.0 = 17 secs.
			 * 
			 * With Arcane Focus Level One:
			 *  94.0 = 17 secs.
			 */
			int level = GetFocusLevel();
			double skill = Caster.Skills[SkillName.Spellweaving].Value;

			int duration = 15 + (int)Math.Floor( skill / 24 ) + ( level * 2 ); // 12 + Floor( Skill / 24 ) + ( FocusLevel * 2 )

			Timer.DelayCall( TimeSpan.FromSeconds( duration ), new TimerCallback( StopEffect ) );

			Lock();

			BuffInfo.AddBuff( Caster, new BuffInfo( BuffIcon.EtherealVoyage, 1031613, 1075805, TimeSpan.FromSeconds( duration ), Caster ) );
		}

		private void StopEffect()
		{
			RemoveContext( Caster, true );

			Caster.SendLocalizedMessage( 1074771 ); // You are no longer under the effects of Ethereal Voyage.			
			
			BuffInfo.RemoveBuff( Caster, BuffIcon.EtherealVoyage );
		}
	}
}