using System;
using Server;

namespace Server.Items
{
    public class ArcaneFocus : ExpireItem
    {
        public override int LabelNumber { get { return 1032629; } } // Arcane Focus

        private int m_Level;

        [CommandProperty( AccessLevel.Counselor, AccessLevel.GameMaster )]
        public int Level
        {
            get { return m_Level; }
			set
			{				
				m_Level = value;

				if( value == 0 )
					Delete();
			}
        }

		private Mobile m_Owner;

		[CommandProperty( AccessLevel.Counselor )]
		public Mobile Owner
		{
			get { return m_Owner; }
		}

        public ArcaneFocus( int lifeSpan, int level, Mobile owner ) : base( 0x3155, lifeSpan )
        {
            LootType = LootType.Blessed;
            m_Level = level;
			m_Owner = owner;
        }

        public ArcaneFocus( Serial serial ) : base( serial )
        {
        }
        
        #region OnDropped > Delete()
        public override bool OnDroppedToMobile( Mobile from, Mobile target )
        {
            if( from == target )
                return base.OnDroppedToMobile( from, target );

            Delete();
            return false;
        }

        public override bool OnDroppedInto( Mobile from, Container target, Point3D p )
        {
            if( target == from.Backpack )
                return base.OnDroppedInto( from, target, p );

            Delete();
            return false;
        }

        public override bool OnDroppedOnto( Mobile from, Item target )
        {
            if( target == from.Backpack )
                return base.OnDroppedOnto( from, target );

            Delete();
            return false;
        }

        public override bool OnDroppedToWorld( Mobile from, Point3D p )
        {
            Delete();
            return false;
        }
        #endregion

        public override void GetProperties( ObjectPropertyList list )
        {
            base.GetProperties( list );

            list.Add( 1060485, Level.ToString() ); // strength bonus ~1_val~
        }

		public override void OnDelete()
		{
			if( m_Owner != null )
				m_Owner.SendLocalizedMessage( 1073480 ); // Your arcane focus disappears.

			base.OnDelete();
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int)1 );

			writer.Write( m_Owner );
			writer.Write( m_Level );
		}

        public override void Deserialize( GenericReader reader )
        {
            base.Deserialize( reader );
            int version = reader.ReadInt();

			if( version > 0 )
			{
				m_Owner = reader.ReadMobile();
				m_Level = reader.ReadInt();
			}
			else
			{
				Delete();
			}
        }
    }
}