using System;
using System.Collections.Generic;
using Server;

namespace Server.Items
{
    public class ExpireItem : Item
    {
        private int m_LifeSpan;

        [CommandProperty( AccessLevel.Counselor, AccessLevel.GameMaster )]
        public int LifeSpan
        {
            get { return m_LifeSpan; }
            set { m_LifeSpan = value; }
        }

        private DateTime m_LastUpdate;

        public static void Initialize()
        {
            EventSink.Login += new LoginEventHandler( OnLogin );
        }

        public static void OnLogin( LoginEventArgs e )
        {
			Mobile from = e.Mobile;

			if( from == null || from.Backpack == null || from.Backpack.Deleted )
				return;

// 			List<ExpireItem> expires = from.Backpack.FindItemsByType( typeof( ExpireItem ) );
// 
// 			for( int i = 0; i < expires.Count; i++ )
// 			{
// 				expires[i].Update_Callback();
// 			}
			
			Item[] expires = from.Backpack.FindItemsByType( typeof( ExpireItem ) );

			foreach ( ExpireItem expir in expires )
			{
				expir.Update_Callback();
			}

			
        }

        public ExpireItem( int itemID, int lifeSpan ) : base( itemID )
        {
            m_LifeSpan = lifeSpan;

            m_LastUpdate = DateTime.Now;
            Timer.DelayCall( TimeSpan.FromSeconds( 7.0 ), new TimerCallback( Update_Callback ) );
        }

        public ExpireItem( Serial serial ) : base( serial )
        {
            m_LastUpdate = DateTime.Now;
            Timer.DelayCall( TimeSpan.FromSeconds( 7.0 ), new TimerCallback( Update_Callback ) );
        }

        private void Update_Callback()
        {
            if( Deleted )
                return;

            LifeSpan -= (int)( Math.Floor( ( DateTime.Now - m_LastUpdate ).TotalSeconds ) );

            Mobile beholder = RootParentEntity as Mobile;

            if( beholder == null || beholder.Deleted )
            {
                Delete();
                return;
            }
            else if( beholder.NetState != null )
            {
                if( LifeSpan <= 0 )
                {
                    Effects.PlaySound( GetWorldLocation(), Map, 0x201 );

                    if( beholder != null )
                        beholder.SendLocalizedMessage( 1072515, "#" + LabelNumber ); // The ~1_name~ expired...

                    Delete();
                    return;
                }
            }
            else // Stop invalidation.
            {
                return;
            }

            InvalidateProperties();

            m_LastUpdate = DateTime.Now;
            Timer.DelayCall( TimeSpan.FromSeconds( 6.0 ), new TimerCallback( Update_Callback ) );
        }

        public override void GetProperties( ObjectPropertyList list )
        {
            base.GetProperties( list );
            list.Add( 1072517, LifeSpan.ToString() ); // Lifespan: ~1_val~ seconds
        }

        public override void Serialize( GenericWriter writer )
        {
            base.Serialize( writer );
            writer.Write( (int)0 );

            writer.Write( m_LifeSpan );
        }

        public override void Deserialize( GenericReader reader )
        {
            base.Deserialize( reader );
            int version = reader.ReadInt();

            m_LifeSpan = reader.ReadInt();
        }
    }
}