using System;
using Server.Mobiles;
using Server.Items;

namespace Server.Spells.Spellweaving
{
	public class NatureFurySpell : ArcaneSummon
	{
		private static SpellInfo m_Info = new SpellInfo(
                "Nature's Fury", "Rauvvrae",
                SpellCircle.Fourth, // 0.5 + 1.0 = 1.5s base cast delay
				-1,
				false
			);

        public override double RequiredSkill { get { return 0.0; } }
        public override int RequiredMana { get { return 24; } }

        public NatureFurySpell( Mobile caster, Item scroll ) : base( caster, scroll, m_Info )
		{
		}

		public override Type Type
      { 
         get
         {
            Spellbook atkBook = Spellbook.FindEquippedSpellbook( Caster );
            
            if ( atkBook is ArcanumIgnis )
               return typeof( FireFury );
            else
               return typeof( NatureFury );         
         }
      }
      
		public override int Sound
      { 
         get
         {
            Spellbook atkBook = Spellbook.FindEquippedSpellbook( Caster );
            
            if ( atkBook is ArcanumIgnis )
               return 0x5CF;
            else
               return 0x5CB;         
         }
      }
      
		public override bool TargetLocation { get { return true; } }
		public override bool Focused { get { return false; } }
		public override bool Controlled { get { return false; } }

		public override int DurationBase { get { return 25; } }
		public override int DurationFocusBonus { get { return 2; } }
		public override int DurationSkillBonus { get { return 1; } }

		public override void OnSummoned( BaseCreature bc )
		{
			if( bc != null )
			{
				bc.SetDamage( bc.DamageMin + GetFocusLevel(), bc.DamageMax + GetFocusLevel() );
				
				if ( bc is FireFury )
      			((FireFury)bc).ConvertToSummon();
         }
		}
	}
}