using System;

namespace Server.Spells.Spellweaving
{
	public class ReaperFormSpell : ArcaneForm
	{
		private static SpellInfo m_Info = new SpellInfo(
                "Reaper Form", "Tarisstree",
                SpellCircle.Sixth, // 0 + 1.5 = 1.5s base cast delay
				-1
			);

        public override double RequiredSkill { get { return 24.0; } }
        public override int RequiredMana { get { return 34; } }

		public override int Body { get { return 0x11D; } }

		public override int FireResistOffset { get { return -25; } }
		public override int PhysResistOffset { get { return 5 + GetFocusLevel(); } }		
		public override int ColdResistOffset { get { return 5 + GetFocusLevel(); } }
		public override int PoisResistOffset { get { return 5 + GetFocusLevel(); } }
		public override int NrgyResistOffset { get { return 5 + GetFocusLevel(); } }

		public override bool SpeedPenalty { get { return true; } }
		public override int SwingBonus { get { return 10 + GetFocusLevel(); } }
		public override int SDIBonus { get { return 10 + GetFocusLevel(); } }

        public ReaperFormSpell( Mobile caster, Item scroll ) : base( caster, scroll, m_Info )
		{
		}

		public override void PlayEffect( Mobile m )
		{
			m.PlaySound( 0x1BA );
		}

		public static int GetSwingBonus( Mobile m )
		{
			if( UnderTransformation( m, typeof( ReaperFormSpell ) ) )
				return GetContext( m ).SwingBonus;

			return 0;
		}

		public static int GetSDIBonus( Mobile m )
		{
			if( UnderTransformation( m, typeof( ReaperFormSpell ) ) )
				return GetContext( m ).SDIBonus;

			return 0;
		}
	}
}