using System;
using System.Collections;
using System.Collections.Generic;

namespace Server.Spells.Spellweaving
{
	public class ThunderstormSpell : ArcanistSpell
	{
		private static SpellInfo m_Info = new SpellInfo(
                "Thunderstorm", "Erelonia",
                SpellCircle.Fourth, // 0.5 + 1.0 = 1.5s base cast delay
				-1
			);

        public override double RequiredSkill { get { return 10.0; } }
        public override int RequiredMana { get { return 32; } }

        public ThunderstormSpell( Mobile caster, Item scroll ) : base( caster, scroll, m_Info )
		{
		}

		public override void OnCast()
		{
			if( CheckSequence() )
			{
				Caster.PlaySound( 0x5CE );

				int level = GetFocusLevel();
				double skill = Caster.Skills[SkillName.Spellweaving].Value;

				int tiles = 3 + level; // 2 + FocusLevel
				int damage = (int)Math.Floor( skill / 4 ) + level; // Floor( Skill / 12 ) + FocusLevel
				int duration = (int)Math.Floor( skill / 24 ) + level; // Floor( Skill / 24 ) + FocusLevel
				int fcrMalus = 1;

				List<Mobile> targets = new List<Mobile>();

				foreach( Mobile m in Caster.GetMobilesInRange( tiles ) )
					if( Caster != m && Caster.InLOS( m ) && SpellHelper.ValidIndirectTarget( Caster, m ) && Caster.CanBeHarmful( m, false ) )
						targets.Add( m );

				for( int i = 0; i < targets.Count; i++ )
				{
					Mobile m = targets[i];

					Caster.DoHarmful( m );

					Spell oldSpell = m.Spell as Spell;
					bool wasCasting = oldSpell != null && oldSpell.IsCasting;

					SpellHelper.Damage( this, m, damage, 100, 0, 0, 0, 0 );

					if( ( wasCasting && !oldSpell.IsCasting ) )
					{
						if( CheckResisted( m ) )
						{
							m.SendLocalizedMessage( 501783 ); // You feel yourself resisting magical energy.
						}
						else
						{
							m_Table[m] = new ThunderstormInfo( m, fcrMalus, TimeSpan.FromSeconds( duration ) );

							BuffInfo.AddBuff( m, new BuffInfo( BuffIcon.Thunderstorm, 1075800, 1075801, TimeSpan.FromSeconds( duration ), m, new TextDefinition( ToTicksString( fcrMalus ) ) ) );
						}
					}
				}
			}

			FinishSequence();
		}

		private static Hashtable m_Table = new Hashtable();

		private class ThunderstormInfo
		{
			public Mobile m_Defender;
			public int m_FCRMalus;
			public ExpireTimer m_Timer;

			public ThunderstormInfo( Mobile defender, int fcrMalus, TimeSpan duration )
			{
				m_Defender = defender;
				m_FCRMalus = fcrMalus;

				m_Timer = new ExpireTimer( m_Defender, duration );
				m_Timer.Start();
			}
		}

		public static int GetCastRecoveryMalus( Mobile m )
		{
			ThunderstormInfo info = m_Table[m] as ThunderstormInfo;

			if( info == null )
				return 0;

			return info.m_FCRMalus;
		}

		public static bool StopDebuffing( Mobile m, bool message )
		{
			ThunderstormInfo info = m_Table[m] as ThunderstormInfo;

			if( info == null || info.m_Timer == null )
				return false;

			info.m_Timer.DoExpire( message );
			return true;
		}

		private class ExpireTimer : Timer
		{
			private Mobile m_Mobile;

			public ExpireTimer( Mobile m, TimeSpan delay ) : base( delay )
			{
				m_Mobile = m;
			}

			protected override void OnTick()
			{
				DoExpire( true );
			}

			public void DoExpire( bool message )
			{
				Stop();
				/*
				if( message )
				{
				}
				*/
				m_Table.Remove( m_Mobile );

				BuffInfo.RemoveBuff( m_Mobile, BuffIcon.Thunderstorm );
			}
		}
	}
}