using System;
using Server.Targeting;
using Server.Network;

namespace Server.Spells.Spellweaving
{
	public class WordOfDeathSpell : ArcanistSpell
	{
		private static SpellInfo m_Info = new SpellInfo(
                "Word of Death", "Nyraxle",
                SpellCircle.Twelveth, // 0.5 + 3.0 = 3.5s base cast delay
				-1
			);

        public override double RequiredSkill { get { return 80.0; } }
        public override int RequiredMana { get { return 50; } }

        public WordOfDeathSpell( Mobile caster, Item scroll ) : base( caster, scroll, m_Info )
		{
		}

		public override void OnCast()
		{
			Caster.Target = new InternalTarget( this );
		}

		public void Target( Mobile m )
		{
			if( CheckHSequence( m ) )
			{
				Point3D loc = m.Location;
				loc.Z += 50;

				m.PlaySound( 0x211 );
				m.FixedParticles( 0x3779, 1, 30, 0x26EC, 0x3, 0x3, EffectLayer.Waist );

				Effects.SendMovingParticles( new Entity( Serial.Zero, loc, m.Map ), m, 0xF5F, 1, 0, true, false, 0x21, 0x3F, 0x251D, 0, 0, EffectLayer.Head, 0 );

				int level = GetFocusLevel();
				int percent = Math.Max( 5, Math.Min( 5 + 5 * level, 30 ) ); // Max( 5, Min( 30, 5 + ( 5 * FocusLevel ) ) )

				bool ready = !m.Player && ( m.Hits < ( m.HitsMax * percent / 100 ) ); // Osi Acurrate

				if( ready )
				{
					SpellHelper.ChaosDamage( this, m, GetNewAosDamage( 350, 1, 5, m ) );
				}
				else
				{
					SpellHelper.ChaosDamage( this, m, GetNewAosDamage( 50, 1, 5, m ) ); 
				}
			}

			FinishSequence();
		}

		public class InternalTarget : Target
		{
			private WordOfDeathSpell m_Owner;

			public InternalTarget( WordOfDeathSpell owner ) : base( 12, false, TargetFlags.Harmful )
			{
				m_Owner = owner;
			}

			protected override void OnTarget( Mobile m, object o )
			{
				if( o is Mobile )
				{
					m_Owner.Target( (Mobile)o );
				}
			}

			protected override void OnTargetFinish( Mobile m )
			{
				m_Owner.FinishSequence();
			}
		}
	}
}